/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.S3Object;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3ObjectMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bucket").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final S3ObjectMarshaller INSTANCE = new S3ObjectMarshaller();

    private S3ObjectMarshaller() {
    }

    public static S3ObjectMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3Object s3Object, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3Object, (String)"s3Object");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3Object.bucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3Object.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)s3Object.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

