/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecognizeCelebritiesRequestMarshaller
implements Marshaller<Request<RecognizeCelebritiesRequest>, RecognizeCelebritiesRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("RekognitionService.RecognizeCelebrities").serviceName("Amazon Rekognition").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public RecognizeCelebritiesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RecognizeCelebritiesRequest> marshall(RecognizeCelebritiesRequest recognizeCelebritiesRequest) {
        Validate.paramNotNull((Object)((Object)recognizeCelebritiesRequest), (String)"recognizeCelebritiesRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)recognizeCelebritiesRequest);
            protocolMarshaller.startMarshalling();
            RecognizeCelebritiesRequestModelMarshaller.getInstance().marshall(recognizeCelebritiesRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

