/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.ModerationLabel;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModerationLabelMarshaller {
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> PARENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentName").isBinary(false).build();
    private static final ModerationLabelMarshaller INSTANCE = new ModerationLabelMarshaller();

    private ModerationLabelMarshaller() {
    }

    public static ModerationLabelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModerationLabel moderationLabel, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)moderationLabel, (String)"moderationLabel");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)moderationLabel.confidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall((Object)moderationLabel.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)moderationLabel.parentName(), PARENTNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

