/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.DetectFacesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DetectFacesRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Image").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final DetectFacesRequestModelMarshaller INSTANCE = new DetectFacesRequestModelMarshaller();

    private DetectFacesRequestModelMarshaller() {
    }

    public static DetectFacesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DetectFacesRequest detectFacesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)detectFacesRequest), (String)"detectFacesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)detectFacesRequest.image(), IMAGE_BINDING);
            protocolMarshaller.marshall(detectFacesRequest.attributesStrings(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

