/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.Beard;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BeardMarshaller {
    private static final MarshallingInfo<Boolean> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").isBinary(false).build();
    private static final BeardMarshaller INSTANCE = new BeardMarshaller();

    private BeardMarshaller() {
    }

    public static BeardMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Beard beard, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)beard, (String)"beard");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)beard.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)beard.confidence(), CONFIDENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

