/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.GenderType;
import software.amazon.awssdk.services.rekognition.transform.GenderMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Gender
implements StructuredPojo,
ToCopyableBuilder<Builder, Gender> {
    private final String value;
    private final Float confidence;

    private Gender(BuilderImpl builder) {
        this.value = builder.value;
        this.confidence = builder.confidence;
    }

    public GenderType value() {
        return GenderType.fromValue(this.value);
    }

    public String valueString() {
        return this.value;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.valueString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gender)) {
            return false;
        }
        Gender other = (Gender)obj;
        return Objects.equals(this.valueString(), other.valueString()) && Objects.equals(this.confidence(), other.confidence());
    }

    public String toString() {
        return ToString.builder((String)"Gender").add("Value", (Object)this.valueString()).add("Confidence", (Object)this.confidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.of(clazz.cast(this.valueString()));
            }
            case "Confidence": {
                return Optional.of(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GenderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Gender model) {
            this.value(model.value);
            this.confidence(model.confidence);
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(GenderType value) {
            this.value(value.toString());
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public Gender build() {
            return new Gender(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Gender> {
        public Builder value(String var1);

        public Builder value(GenderType var1);

        public Builder confidence(Float var1);
    }
}

