/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.BoundingBoxMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BoundingBox
implements StructuredPojo,
ToCopyableBuilder<Builder, BoundingBox> {
    private final Float width;
    private final Float height;
    private final Float left;
    private final Float top;

    private BoundingBox(BuilderImpl builder) {
        this.width = builder.width;
        this.height = builder.height;
        this.left = builder.left;
        this.top = builder.top;
    }

    public Float width() {
        return this.width;
    }

    public Float height() {
        return this.height;
    }

    public Float left() {
        return this.left;
    }

    public Float top() {
        return this.top;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.left());
        hashCode = 31 * hashCode + Objects.hashCode(this.top());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoundingBox)) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        return Objects.equals(this.width(), other.width()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.left(), other.left()) && Objects.equals(this.top(), other.top());
    }

    public String toString() {
        return ToString.builder((String)"BoundingBox").add("Width", (Object)this.width()).add("Height", (Object)this.height()).add("Left", (Object)this.left()).add("Top", (Object)this.top()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Width": {
                return Optional.of(clazz.cast(this.width()));
            }
            case "Height": {
                return Optional.of(clazz.cast(this.height()));
            }
            case "Left": {
                return Optional.of(clazz.cast(this.left()));
            }
            case "Top": {
                return Optional.of(clazz.cast(this.top()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BoundingBoxMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Float width;
        private Float height;
        private Float left;
        private Float top;

        private BuilderImpl() {
        }

        private BuilderImpl(BoundingBox model) {
            this.width(model.width);
            this.height(model.height);
            this.left(model.left);
            this.top(model.top);
        }

        public final Float getWidth() {
            return this.width;
        }

        @Override
        public final Builder width(Float width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Float width) {
            this.width = width;
        }

        public final Float getHeight() {
            return this.height;
        }

        @Override
        public final Builder height(Float height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Float height) {
            this.height = height;
        }

        public final Float getLeft() {
            return this.left;
        }

        @Override
        public final Builder left(Float left) {
            this.left = left;
            return this;
        }

        public final void setLeft(Float left) {
            this.left = left;
        }

        public final Float getTop() {
            return this.top;
        }

        @Override
        public final Builder top(Float top) {
            this.top = top;
            return this;
        }

        public final void setTop(Float top) {
            this.top = top;
        }

        public BoundingBox build() {
            return new BoundingBox(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BoundingBox> {
        public Builder width(Float var1);

        public Builder height(Float var1);

        public Builder left(Float var1);

        public Builder top(Float var1);
    }
}

