/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;

public final class ListCollectionsPaginator
implements SdkIterable<ListCollectionsResponse> {
    private final RekognitionClient client;
    private final ListCollectionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListCollectionsPaginator(RekognitionClient client, ListCollectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCollectionsResponseFetcher();
    }

    public Iterator<ListCollectionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> collectionIds() {
        Function<ListCollectionsResponse, Iterator> getIterator = response -> response != null ? response.collectionIds().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListCollectionsResponseFetcher
    implements NextPageFetcher<ListCollectionsResponse> {
        private ListCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollectionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListCollectionsResponse nextPage(ListCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListCollectionsPaginator.this.client.listCollections(ListCollectionsPaginator.this.firstRequest);
            }
            return ListCollectionsPaginator.this.client.listCollections((ListCollectionsRequest)((Object)ListCollectionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

