/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rekognition.model.Celebrity;
import software.amazon.awssdk.services.rekognition.model.CelebrityListCopier;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.ComparedFaceListCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecognizeCelebritiesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, RecognizeCelebritiesResponse> {
    private final List<Celebrity> celebrityFaces;
    private final List<ComparedFace> unrecognizedFaces;
    private final String orientationCorrection;

    private RecognizeCelebritiesResponse(BuilderImpl builder) {
        super(builder);
        this.celebrityFaces = builder.celebrityFaces;
        this.unrecognizedFaces = builder.unrecognizedFaces;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public List<Celebrity> celebrityFaces() {
        return this.celebrityFaces;
    }

    public List<ComparedFace> unrecognizedFaces() {
        return this.unrecognizedFaces;
    }

    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(this.orientationCorrection);
    }

    public String orientationCorrectionString() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.celebrityFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.unrecognizedFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationCorrectionString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeCelebritiesResponse)) {
            return false;
        }
        RecognizeCelebritiesResponse other = (RecognizeCelebritiesResponse)((Object)obj);
        return Objects.equals(this.celebrityFaces(), other.celebrityFaces()) && Objects.equals(this.unrecognizedFaces(), other.unrecognizedFaces()) && Objects.equals(this.orientationCorrectionString(), other.orientationCorrectionString());
    }

    public String toString() {
        return ToString.builder((String)"RecognizeCelebritiesResponse").add("CelebrityFaces", this.celebrityFaces()).add("UnrecognizedFaces", this.unrecognizedFaces()).add("OrientationCorrection", (Object)this.orientationCorrectionString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CelebrityFaces": {
                return Optional.of(clazz.cast(this.celebrityFaces()));
            }
            case "UnrecognizedFaces": {
                return Optional.of(clazz.cast(this.unrecognizedFaces()));
            }
            case "OrientationCorrection": {
                return Optional.of(clazz.cast(this.orientationCorrectionString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<Celebrity> celebrityFaces;
        private List<ComparedFace> unrecognizedFaces;
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeCelebritiesResponse model) {
            this.celebrityFaces(model.celebrityFaces);
            this.unrecognizedFaces(model.unrecognizedFaces);
            this.orientationCorrection(model.orientationCorrection);
        }

        public final Collection<Celebrity.Builder> getCelebrityFaces() {
            return this.celebrityFaces != null ? (Collection)this.celebrityFaces.stream().map(Celebrity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder celebrityFaces(Collection<Celebrity> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copy(celebrityFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrityFaces(Celebrity ... celebrityFaces) {
            this.celebrityFaces(Arrays.asList(celebrityFaces));
            return this;
        }

        public final void setCelebrityFaces(Collection<Celebrity.BuilderImpl> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copyFromBuilder(celebrityFaces);
        }

        public final Collection<ComparedFace.Builder> getUnrecognizedFaces() {
            return this.unrecognizedFaces != null ? (Collection)this.unrecognizedFaces.stream().map(ComparedFace::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unrecognizedFaces(Collection<ComparedFace> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copy(unrecognizedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unrecognizedFaces(ComparedFace ... unrecognizedFaces) {
            this.unrecognizedFaces(Arrays.asList(unrecognizedFaces));
            return this;
        }

        public final void setUnrecognizedFaces(Collection<ComparedFace.BuilderImpl> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copyFromBuilder(unrecognizedFaces);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public RecognizeCelebritiesResponse build() {
            return new RecognizeCelebritiesResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, RecognizeCelebritiesResponse> {
        public Builder celebrityFaces(Collection<Celebrity> var1);

        public Builder celebrityFaces(Celebrity ... var1);

        public Builder unrecognizedFaces(Collection<ComparedFace> var1);

        public Builder unrecognizedFaces(ComparedFace ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

