/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.Mustache;

public class MustacheUnmarshaller
implements Unmarshaller<Mustache, JsonUnmarshallerContext> {
    private static final MustacheUnmarshaller INSTANCE = new MustacheUnmarshaller();

    public Mustache unmarshall(JsonUnmarshallerContext context) throws Exception {
        Mustache.Builder mustacheBuilder = Mustache.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    mustacheBuilder.value((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Confidence", targetDepth)) {
                    context.nextToken();
                    mustacheBuilder.confidence((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Mustache)mustacheBuilder.build();
    }

    public static MustacheUnmarshaller getInstance() {
        return INSTANCE;
    }
}

