/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.MouthOpen;

@SdkInternalApi
public class MouthOpenMarshaller {
    private static final MarshallingInfo<Boolean> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").build();
    private static final MouthOpenMarshaller INSTANCE = new MouthOpenMarshaller();

    public static MouthOpenMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MouthOpen mouthOpen, ProtocolMarshaller protocolMarshaller) {
        if (mouthOpen == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mouthOpen.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)mouthOpen.confidence(), CONFIDENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

