/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;

public final class ListFacesPaginator
implements SdkIterable<ListFacesResponse> {
    private final RekognitionClient client;
    private final ListFacesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListFacesPaginator(RekognitionClient client, ListFacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFacesResponseFetcher();
    }

    public Iterator<ListFacesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Face> faces() {
        Function<ListFacesResponse, Iterator> getIterator = response -> response != null ? response.faces().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListFacesResponseFetcher
    implements NextPageFetcher<ListFacesResponse> {
        private ListFacesResponseFetcher() {
        }

        public boolean hasNextPage(ListFacesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListFacesResponse nextPage(ListFacesResponse previousPage) {
            if (previousPage == null) {
                return ListFacesPaginator.this.client.listFaces(ListFacesPaginator.this.firstRequest);
            }
            return ListFacesPaginator.this.client.listFaces((ListFacesRequest)((Object)ListFacesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

