/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ImageQualityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageQuality
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageQuality> {
    private final Float brightness;
    private final Float sharpness;

    private ImageQuality(BuilderImpl builder) {
        this.brightness = builder.brightness;
        this.sharpness = builder.sharpness;
    }

    public Float brightness() {
        return this.brightness;
    }

    public Float sharpness() {
        return this.sharpness;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brightness());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharpness());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageQuality)) {
            return false;
        }
        ImageQuality other = (ImageQuality)obj;
        return Objects.equals(this.brightness(), other.brightness()) && Objects.equals(this.sharpness(), other.sharpness());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.brightness() != null) {
            sb.append("Brightness: ").append(this.brightness()).append(",");
        }
        if (this.sharpness() != null) {
            sb.append("Sharpness: ").append(this.sharpness()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Brightness": {
                return Optional.of(clazz.cast(this.brightness()));
            }
            case "Sharpness": {
                return Optional.of(clazz.cast(this.sharpness()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageQualityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Float brightness;
        private Float sharpness;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageQuality model) {
            this.brightness(model.brightness);
            this.sharpness(model.sharpness);
        }

        public final Float getBrightness() {
            return this.brightness;
        }

        @Override
        public final Builder brightness(Float brightness) {
            this.brightness = brightness;
            return this;
        }

        public final void setBrightness(Float brightness) {
            this.brightness = brightness;
        }

        public final Float getSharpness() {
            return this.sharpness;
        }

        @Override
        public final Builder sharpness(Float sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final void setSharpness(Float sharpness) {
            this.sharpness = sharpness;
        }

        public ImageQuality build() {
            return new ImageQuality(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageQuality> {
        public Builder brightness(Float var1);

        public Builder sharpness(Float var1);
    }
}

