/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;

@SdkInternalApi
public class IndexFacesRequestModelMarshaller {
    private static final MarshallingInfo<String> COLLECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CollectionId").build();
    private static final MarshallingInfo<StructuredPojo> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Image").build();
    private static final MarshallingInfo<String> EXTERNALIMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalImageId").build();
    private static final MarshallingInfo<List> DETECTIONATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetectionAttributes").build();
    private static final IndexFacesRequestModelMarshaller INSTANCE = new IndexFacesRequestModelMarshaller();

    public static IndexFacesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IndexFacesRequest indexFacesRequest, ProtocolMarshaller protocolMarshaller) {
        if (indexFacesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)indexFacesRequest.collectionId(), COLLECTIONID_BINDING);
            protocolMarshaller.marshall((Object)indexFacesRequest.image(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)indexFacesRequest.externalImageId(), EXTERNALIMAGEID_BINDING);
            protocolMarshaller.marshall(indexFacesRequest.detectionAttributesStrings(), DETECTIONATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

