/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.ImageQuality;

@SdkInternalApi
public class ImageQualityMarshaller {
    private static final MarshallingInfo<Float> BRIGHTNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Brightness").build();
    private static final MarshallingInfo<Float> SHARPNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sharpness").build();
    private static final ImageQualityMarshaller INSTANCE = new ImageQualityMarshaller();

    public static ImageQualityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImageQuality imageQuality, ProtocolMarshaller protocolMarshaller) {
        if (imageQuality == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageQuality.brightness(), BRIGHTNESS_BINDING);
            protocolMarshaller.marshall((Object)imageQuality.sharpness(), SHARPNESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

