/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.FaceRecord;
import software.amazon.awssdk.services.rekognition.transform.FaceDetailUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.FaceUnmarshaller;

public class FaceRecordUnmarshaller
implements Unmarshaller<FaceRecord, JsonUnmarshallerContext> {
    private static final FaceRecordUnmarshaller INSTANCE = new FaceRecordUnmarshaller();

    public FaceRecord unmarshall(JsonUnmarshallerContext context) throws Exception {
        FaceRecord.Builder faceRecordBuilder = FaceRecord.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Face", targetDepth)) {
                    context.nextToken();
                    faceRecordBuilder.face(FaceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("FaceDetail", targetDepth)) {
                    context.nextToken();
                    faceRecordBuilder.faceDetail(FaceDetailUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (FaceRecord)faceRecordBuilder.build();
    }

    public static FaceRecordUnmarshaller getInstance() {
        return INSTANCE;
    }
}

