/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.SunglassesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Sunglasses
implements StructuredPojo,
ToCopyableBuilder<Builder, Sunglasses> {
    private final Boolean value;
    private final Float confidence;

    private Sunglasses(BuilderImpl builder) {
        this.value = builder.value;
        this.confidence = builder.confidence;
    }

    public Boolean value() {
        return this.value;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.confidence() == null ? 0 : this.confidence().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sunglasses)) {
            return false;
        }
        Sunglasses other = (Sunglasses)obj;
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        return other.confidence() == null || other.confidence().equals(this.confidence());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.confidence() != null) {
            sb.append("Confidence: ").append(this.confidence()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "Confidence": {
                return Optional.of(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SunglassesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean value;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Sunglasses model) {
            this.value(model.value);
            this.confidence(model.confidence);
        }

        public final Boolean getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Boolean value) {
            this.value = value;
            return this;
        }

        public final void setValue(Boolean value) {
            this.value = value;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public Sunglasses build() {
            return new Sunglasses(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Sunglasses> {
        public Builder value(Boolean var1);

        public Builder confidence(Float var1);
    }
}

