/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ModerationLabelMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModerationLabel
implements StructuredPojo,
ToCopyableBuilder<Builder, ModerationLabel> {
    private final Float confidence;
    private final String name;
    private final String parentName;

    private ModerationLabel(BuilderImpl builder) {
        this.confidence = builder.confidence;
        this.name = builder.name;
        this.parentName = builder.parentName;
    }

    public Float confidence() {
        return this.confidence;
    }

    public String name() {
        return this.name;
    }

    public String parentName() {
        return this.parentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.confidence() == null ? 0 : this.confidence().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.parentName() == null ? 0 : this.parentName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModerationLabel)) {
            return false;
        }
        ModerationLabel other = (ModerationLabel)obj;
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        if (other.confidence() != null && !other.confidence().equals(this.confidence())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.parentName() == null ^ this.parentName() == null) {
            return false;
        }
        return other.parentName() == null || other.parentName().equals(this.parentName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.confidence() != null) {
            sb.append("Confidence: ").append(this.confidence()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.parentName() != null) {
            sb.append("ParentName: ").append(this.parentName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Confidence": {
                return Optional.of(clazz.cast(this.confidence()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ParentName": {
                return Optional.of(clazz.cast(this.parentName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ModerationLabelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Float confidence;
        private String name;
        private String parentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModerationLabel model) {
            this.confidence(model.confidence);
            this.name(model.name);
            this.parentName(model.parentName);
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getParentName() {
            return this.parentName;
        }

        @Override
        public final Builder parentName(String parentName) {
            this.parentName = parentName;
            return this;
        }

        public final void setParentName(String parentName) {
            this.parentName = parentName;
        }

        public ModerationLabel build() {
            return new ModerationLabel(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModerationLabel> {
        public Builder confidence(Float var1);

        public Builder name(String var1);

        public Builder parentName(String var1);
    }
}

