/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.AgeRange;
import software.amazon.awssdk.services.rekognition.model.Beard;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.Emotion;
import software.amazon.awssdk.services.rekognition.model.EmotionsCopier;
import software.amazon.awssdk.services.rekognition.model.EyeOpen;
import software.amazon.awssdk.services.rekognition.model.Eyeglasses;
import software.amazon.awssdk.services.rekognition.model.Gender;
import software.amazon.awssdk.services.rekognition.model.ImageQuality;
import software.amazon.awssdk.services.rekognition.model.Landmark;
import software.amazon.awssdk.services.rekognition.model.LandmarksCopier;
import software.amazon.awssdk.services.rekognition.model.MouthOpen;
import software.amazon.awssdk.services.rekognition.model.Mustache;
import software.amazon.awssdk.services.rekognition.model.Pose;
import software.amazon.awssdk.services.rekognition.model.Smile;
import software.amazon.awssdk.services.rekognition.model.Sunglasses;
import software.amazon.awssdk.services.rekognition.transform.FaceDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FaceDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, FaceDetail> {
    private final BoundingBox boundingBox;
    private final AgeRange ageRange;
    private final Smile smile;
    private final Eyeglasses eyeglasses;
    private final Sunglasses sunglasses;
    private final Gender gender;
    private final Beard beard;
    private final Mustache mustache;
    private final EyeOpen eyesOpen;
    private final MouthOpen mouthOpen;
    private final List<Emotion> emotions;
    private final List<Landmark> landmarks;
    private final Pose pose;
    private final ImageQuality quality;
    private final Float confidence;

    private FaceDetail(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.ageRange = builder.ageRange;
        this.smile = builder.smile;
        this.eyeglasses = builder.eyeglasses;
        this.sunglasses = builder.sunglasses;
        this.gender = builder.gender;
        this.beard = builder.beard;
        this.mustache = builder.mustache;
        this.eyesOpen = builder.eyesOpen;
        this.mouthOpen = builder.mouthOpen;
        this.emotions = builder.emotions;
        this.landmarks = builder.landmarks;
        this.pose = builder.pose;
        this.quality = builder.quality;
        this.confidence = builder.confidence;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public AgeRange ageRange() {
        return this.ageRange;
    }

    public Smile smile() {
        return this.smile;
    }

    public Eyeglasses eyeglasses() {
        return this.eyeglasses;
    }

    public Sunglasses sunglasses() {
        return this.sunglasses;
    }

    public Gender gender() {
        return this.gender;
    }

    public Beard beard() {
        return this.beard;
    }

    public Mustache mustache() {
        return this.mustache;
    }

    public EyeOpen eyesOpen() {
        return this.eyesOpen;
    }

    public MouthOpen mouthOpen() {
        return this.mouthOpen;
    }

    public List<Emotion> emotions() {
        return this.emotions;
    }

    public List<Landmark> landmarks() {
        return this.landmarks;
    }

    public Pose pose() {
        return this.pose;
    }

    public ImageQuality quality() {
        return this.quality;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.boundingBox() == null ? 0 : this.boundingBox().hashCode());
        hashCode = 31 * hashCode + (this.ageRange() == null ? 0 : this.ageRange().hashCode());
        hashCode = 31 * hashCode + (this.smile() == null ? 0 : this.smile().hashCode());
        hashCode = 31 * hashCode + (this.eyeglasses() == null ? 0 : this.eyeglasses().hashCode());
        hashCode = 31 * hashCode + (this.sunglasses() == null ? 0 : this.sunglasses().hashCode());
        hashCode = 31 * hashCode + (this.gender() == null ? 0 : this.gender().hashCode());
        hashCode = 31 * hashCode + (this.beard() == null ? 0 : this.beard().hashCode());
        hashCode = 31 * hashCode + (this.mustache() == null ? 0 : this.mustache().hashCode());
        hashCode = 31 * hashCode + (this.eyesOpen() == null ? 0 : this.eyesOpen().hashCode());
        hashCode = 31 * hashCode + (this.mouthOpen() == null ? 0 : this.mouthOpen().hashCode());
        hashCode = 31 * hashCode + (this.emotions() == null ? 0 : this.emotions().hashCode());
        hashCode = 31 * hashCode + (this.landmarks() == null ? 0 : this.landmarks().hashCode());
        hashCode = 31 * hashCode + (this.pose() == null ? 0 : this.pose().hashCode());
        hashCode = 31 * hashCode + (this.quality() == null ? 0 : this.quality().hashCode());
        hashCode = 31 * hashCode + (this.confidence() == null ? 0 : this.confidence().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceDetail)) {
            return false;
        }
        FaceDetail other = (FaceDetail)obj;
        if (other.boundingBox() == null ^ this.boundingBox() == null) {
            return false;
        }
        if (other.boundingBox() != null && !other.boundingBox().equals(this.boundingBox())) {
            return false;
        }
        if (other.ageRange() == null ^ this.ageRange() == null) {
            return false;
        }
        if (other.ageRange() != null && !other.ageRange().equals(this.ageRange())) {
            return false;
        }
        if (other.smile() == null ^ this.smile() == null) {
            return false;
        }
        if (other.smile() != null && !other.smile().equals(this.smile())) {
            return false;
        }
        if (other.eyeglasses() == null ^ this.eyeglasses() == null) {
            return false;
        }
        if (other.eyeglasses() != null && !other.eyeglasses().equals(this.eyeglasses())) {
            return false;
        }
        if (other.sunglasses() == null ^ this.sunglasses() == null) {
            return false;
        }
        if (other.sunglasses() != null && !other.sunglasses().equals(this.sunglasses())) {
            return false;
        }
        if (other.gender() == null ^ this.gender() == null) {
            return false;
        }
        if (other.gender() != null && !other.gender().equals(this.gender())) {
            return false;
        }
        if (other.beard() == null ^ this.beard() == null) {
            return false;
        }
        if (other.beard() != null && !other.beard().equals(this.beard())) {
            return false;
        }
        if (other.mustache() == null ^ this.mustache() == null) {
            return false;
        }
        if (other.mustache() != null && !other.mustache().equals(this.mustache())) {
            return false;
        }
        if (other.eyesOpen() == null ^ this.eyesOpen() == null) {
            return false;
        }
        if (other.eyesOpen() != null && !other.eyesOpen().equals(this.eyesOpen())) {
            return false;
        }
        if (other.mouthOpen() == null ^ this.mouthOpen() == null) {
            return false;
        }
        if (other.mouthOpen() != null && !other.mouthOpen().equals(this.mouthOpen())) {
            return false;
        }
        if (other.emotions() == null ^ this.emotions() == null) {
            return false;
        }
        if (other.emotions() != null && !other.emotions().equals(this.emotions())) {
            return false;
        }
        if (other.landmarks() == null ^ this.landmarks() == null) {
            return false;
        }
        if (other.landmarks() != null && !other.landmarks().equals(this.landmarks())) {
            return false;
        }
        if (other.pose() == null ^ this.pose() == null) {
            return false;
        }
        if (other.pose() != null && !other.pose().equals(this.pose())) {
            return false;
        }
        if (other.quality() == null ^ this.quality() == null) {
            return false;
        }
        if (other.quality() != null && !other.quality().equals(this.quality())) {
            return false;
        }
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        return other.confidence() == null || other.confidence().equals(this.confidence());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.boundingBox() != null) {
            sb.append("BoundingBox: ").append(this.boundingBox()).append(",");
        }
        if (this.ageRange() != null) {
            sb.append("AgeRange: ").append(this.ageRange()).append(",");
        }
        if (this.smile() != null) {
            sb.append("Smile: ").append(this.smile()).append(",");
        }
        if (this.eyeglasses() != null) {
            sb.append("Eyeglasses: ").append(this.eyeglasses()).append(",");
        }
        if (this.sunglasses() != null) {
            sb.append("Sunglasses: ").append(this.sunglasses()).append(",");
        }
        if (this.gender() != null) {
            sb.append("Gender: ").append(this.gender()).append(",");
        }
        if (this.beard() != null) {
            sb.append("Beard: ").append(this.beard()).append(",");
        }
        if (this.mustache() != null) {
            sb.append("Mustache: ").append(this.mustache()).append(",");
        }
        if (this.eyesOpen() != null) {
            sb.append("EyesOpen: ").append(this.eyesOpen()).append(",");
        }
        if (this.mouthOpen() != null) {
            sb.append("MouthOpen: ").append(this.mouthOpen()).append(",");
        }
        if (this.emotions() != null) {
            sb.append("Emotions: ").append(this.emotions()).append(",");
        }
        if (this.landmarks() != null) {
            sb.append("Landmarks: ").append(this.landmarks()).append(",");
        }
        if (this.pose() != null) {
            sb.append("Pose: ").append(this.pose()).append(",");
        }
        if (this.quality() != null) {
            sb.append("Quality: ").append(this.quality()).append(",");
        }
        if (this.confidence() != null) {
            sb.append("Confidence: ").append(this.confidence()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.of(clazz.cast(this.boundingBox()));
            }
            case "AgeRange": {
                return Optional.of(clazz.cast(this.ageRange()));
            }
            case "Smile": {
                return Optional.of(clazz.cast(this.smile()));
            }
            case "Eyeglasses": {
                return Optional.of(clazz.cast(this.eyeglasses()));
            }
            case "Sunglasses": {
                return Optional.of(clazz.cast(this.sunglasses()));
            }
            case "Gender": {
                return Optional.of(clazz.cast(this.gender()));
            }
            case "Beard": {
                return Optional.of(clazz.cast(this.beard()));
            }
            case "Mustache": {
                return Optional.of(clazz.cast(this.mustache()));
            }
            case "EyesOpen": {
                return Optional.of(clazz.cast(this.eyesOpen()));
            }
            case "MouthOpen": {
                return Optional.of(clazz.cast(this.mouthOpen()));
            }
            case "Emotions": {
                return Optional.of(clazz.cast(this.emotions()));
            }
            case "Landmarks": {
                return Optional.of(clazz.cast(this.landmarks()));
            }
            case "Pose": {
                return Optional.of(clazz.cast(this.pose()));
            }
            case "Quality": {
                return Optional.of(clazz.cast(this.quality()));
            }
            case "Confidence": {
                return Optional.of(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private AgeRange ageRange;
        private Smile smile;
        private Eyeglasses eyeglasses;
        private Sunglasses sunglasses;
        private Gender gender;
        private Beard beard;
        private Mustache mustache;
        private EyeOpen eyesOpen;
        private MouthOpen mouthOpen;
        private List<Emotion> emotions;
        private List<Landmark> landmarks;
        private Pose pose;
        private ImageQuality quality;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceDetail model) {
            this.boundingBox(model.boundingBox);
            this.ageRange(model.ageRange);
            this.smile(model.smile);
            this.eyeglasses(model.eyeglasses);
            this.sunglasses(model.sunglasses);
            this.gender(model.gender);
            this.beard(model.beard);
            this.mustache(model.mustache);
            this.eyesOpen(model.eyesOpen);
            this.mouthOpen(model.mouthOpen);
            this.emotions(model.emotions);
            this.landmarks(model.landmarks);
            this.pose(model.pose);
            this.quality(model.quality);
            this.confidence(model.confidence);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final AgeRange.Builder getAgeRange() {
            return this.ageRange != null ? this.ageRange.toBuilder() : null;
        }

        @Override
        public final Builder ageRange(AgeRange ageRange) {
            this.ageRange = ageRange;
            return this;
        }

        public final void setAgeRange(AgeRange.BuilderImpl ageRange) {
            this.ageRange = ageRange != null ? ageRange.build() : null;
        }

        public final Smile.Builder getSmile() {
            return this.smile != null ? this.smile.toBuilder() : null;
        }

        @Override
        public final Builder smile(Smile smile) {
            this.smile = smile;
            return this;
        }

        public final void setSmile(Smile.BuilderImpl smile) {
            this.smile = smile != null ? smile.build() : null;
        }

        public final Eyeglasses.Builder getEyeglasses() {
            return this.eyeglasses != null ? this.eyeglasses.toBuilder() : null;
        }

        @Override
        public final Builder eyeglasses(Eyeglasses eyeglasses) {
            this.eyeglasses = eyeglasses;
            return this;
        }

        public final void setEyeglasses(Eyeglasses.BuilderImpl eyeglasses) {
            this.eyeglasses = eyeglasses != null ? eyeglasses.build() : null;
        }

        public final Sunglasses.Builder getSunglasses() {
            return this.sunglasses != null ? this.sunglasses.toBuilder() : null;
        }

        @Override
        public final Builder sunglasses(Sunglasses sunglasses) {
            this.sunglasses = sunglasses;
            return this;
        }

        public final void setSunglasses(Sunglasses.BuilderImpl sunglasses) {
            this.sunglasses = sunglasses != null ? sunglasses.build() : null;
        }

        public final Gender.Builder getGender() {
            return this.gender != null ? this.gender.toBuilder() : null;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender = gender;
            return this;
        }

        public final void setGender(Gender.BuilderImpl gender) {
            this.gender = gender != null ? gender.build() : null;
        }

        public final Beard.Builder getBeard() {
            return this.beard != null ? this.beard.toBuilder() : null;
        }

        @Override
        public final Builder beard(Beard beard) {
            this.beard = beard;
            return this;
        }

        public final void setBeard(Beard.BuilderImpl beard) {
            this.beard = beard != null ? beard.build() : null;
        }

        public final Mustache.Builder getMustache() {
            return this.mustache != null ? this.mustache.toBuilder() : null;
        }

        @Override
        public final Builder mustache(Mustache mustache) {
            this.mustache = mustache;
            return this;
        }

        public final void setMustache(Mustache.BuilderImpl mustache) {
            this.mustache = mustache != null ? mustache.build() : null;
        }

        public final EyeOpen.Builder getEyesOpen() {
            return this.eyesOpen != null ? this.eyesOpen.toBuilder() : null;
        }

        @Override
        public final Builder eyesOpen(EyeOpen eyesOpen) {
            this.eyesOpen = eyesOpen;
            return this;
        }

        public final void setEyesOpen(EyeOpen.BuilderImpl eyesOpen) {
            this.eyesOpen = eyesOpen != null ? eyesOpen.build() : null;
        }

        public final MouthOpen.Builder getMouthOpen() {
            return this.mouthOpen != null ? this.mouthOpen.toBuilder() : null;
        }

        @Override
        public final Builder mouthOpen(MouthOpen mouthOpen) {
            this.mouthOpen = mouthOpen;
            return this;
        }

        public final void setMouthOpen(MouthOpen.BuilderImpl mouthOpen) {
            this.mouthOpen = mouthOpen != null ? mouthOpen.build() : null;
        }

        public final Collection<Emotion.Builder> getEmotions() {
            return this.emotions != null ? (Collection)this.emotions.stream().map(Emotion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder emotions(Collection<Emotion> emotions) {
            this.emotions = EmotionsCopier.copy(emotions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emotions(Emotion ... emotions) {
            this.emotions(Arrays.asList(emotions));
            return this;
        }

        public final void setEmotions(Collection<Emotion.BuilderImpl> emotions) {
            this.emotions = EmotionsCopier.copyFromBuilder(emotions);
        }

        public final Collection<Landmark.Builder> getLandmarks() {
            return this.landmarks != null ? (Collection)this.landmarks.stream().map(Landmark::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder landmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Landmark ... landmarks) {
            this.landmarks(Arrays.asList(landmarks));
            return this;
        }

        public final void setLandmarks(Collection<Landmark.BuilderImpl> landmarks) {
            this.landmarks = LandmarksCopier.copyFromBuilder(landmarks);
        }

        public final Pose.Builder getPose() {
            return this.pose != null ? this.pose.toBuilder() : null;
        }

        @Override
        public final Builder pose(Pose pose) {
            this.pose = pose;
            return this;
        }

        public final void setPose(Pose.BuilderImpl pose) {
            this.pose = pose != null ? pose.build() : null;
        }

        public final ImageQuality.Builder getQuality() {
            return this.quality != null ? this.quality.toBuilder() : null;
        }

        @Override
        public final Builder quality(ImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public final void setQuality(ImageQuality.BuilderImpl quality) {
            this.quality = quality != null ? quality.build() : null;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public FaceDetail build() {
            return new FaceDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FaceDetail> {
        public Builder boundingBox(BoundingBox var1);

        public Builder ageRange(AgeRange var1);

        public Builder smile(Smile var1);

        public Builder eyeglasses(Eyeglasses var1);

        public Builder sunglasses(Sunglasses var1);

        public Builder gender(Gender var1);

        public Builder beard(Beard var1);

        public Builder mustache(Mustache var1);

        public Builder eyesOpen(EyeOpen var1);

        public Builder mouthOpen(MouthOpen var1);

        public Builder emotions(Collection<Emotion> var1);

        public Builder emotions(Emotion ... var1);

        public Builder landmarks(Collection<Landmark> var1);

        public Builder landmarks(Landmark ... var1);

        public Builder pose(Pose var1);

        public Builder quality(ImageQuality var1);

        public Builder confidence(Float var1);
    }
}

