/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.Label;
import software.amazon.awssdk.services.rekognition.model.LabelsCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectLabelsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DetectLabelsResponse> {
    private final List<Label> labels;
    private final String orientationCorrection;

    private DetectLabelsResponse(BuilderImpl builder) {
        this.labels = builder.labels;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public List<Label> labels() {
        return this.labels;
    }

    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(this.orientationCorrection);
    }

    public String orientationCorrectionString() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.labels() == null ? 0 : this.labels().hashCode());
        hashCode = 31 * hashCode + (this.orientationCorrectionString() == null ? 0 : this.orientationCorrectionString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResponse)) {
            return false;
        }
        DetectLabelsResponse other = (DetectLabelsResponse)((Object)obj);
        if (other.labels() == null ^ this.labels() == null) {
            return false;
        }
        if (other.labels() != null && !other.labels().equals(this.labels())) {
            return false;
        }
        if (other.orientationCorrectionString() == null ^ this.orientationCorrectionString() == null) {
            return false;
        }
        return other.orientationCorrectionString() == null || other.orientationCorrectionString().equals(this.orientationCorrectionString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.labels() != null) {
            sb.append("Labels: ").append(this.labels()).append(",");
        }
        if (this.orientationCorrectionString() != null) {
            sb.append("OrientationCorrection: ").append(this.orientationCorrectionString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Labels": {
                return Optional.of(clazz.cast(this.labels()));
            }
            case "OrientationCorrection": {
                return Optional.of(clazz.cast(this.orientationCorrectionString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Label> labels;
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsResponse model) {
            this.labels(model.labels);
            this.orientationCorrection(model.orientationCorrection);
        }

        public final Collection<Label.Builder> getLabels() {
            return this.labels != null ? (Collection)this.labels.stream().map(Label::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public DetectLabelsResponse build() {
            return new DetectLabelsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetectLabelsResponse> {
        public Builder labels(Collection<Label> var1);

        public Builder labels(Label ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

