/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.CompareFacesMatch;
import software.amazon.awssdk.services.rekognition.model.CompareFacesMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.CompareFacesUnmatchListCopier;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.ComparedSourceImageFace;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompareFacesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CompareFacesResponse> {
    private final ComparedSourceImageFace sourceImageFace;
    private final List<CompareFacesMatch> faceMatches;
    private final List<ComparedFace> unmatchedFaces;
    private final String sourceImageOrientationCorrection;
    private final String targetImageOrientationCorrection;

    private CompareFacesResponse(BuilderImpl builder) {
        this.sourceImageFace = builder.sourceImageFace;
        this.faceMatches = builder.faceMatches;
        this.unmatchedFaces = builder.unmatchedFaces;
        this.sourceImageOrientationCorrection = builder.sourceImageOrientationCorrection;
        this.targetImageOrientationCorrection = builder.targetImageOrientationCorrection;
    }

    public ComparedSourceImageFace sourceImageFace() {
        return this.sourceImageFace;
    }

    public List<CompareFacesMatch> faceMatches() {
        return this.faceMatches;
    }

    public List<ComparedFace> unmatchedFaces() {
        return this.unmatchedFaces;
    }

    public OrientationCorrection sourceImageOrientationCorrection() {
        return OrientationCorrection.fromValue(this.sourceImageOrientationCorrection);
    }

    public String sourceImageOrientationCorrectionString() {
        return this.sourceImageOrientationCorrection;
    }

    public OrientationCorrection targetImageOrientationCorrection() {
        return OrientationCorrection.fromValue(this.targetImageOrientationCorrection);
    }

    public String targetImageOrientationCorrectionString() {
        return this.targetImageOrientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceImageFace() == null ? 0 : this.sourceImageFace().hashCode());
        hashCode = 31 * hashCode + (this.faceMatches() == null ? 0 : this.faceMatches().hashCode());
        hashCode = 31 * hashCode + (this.unmatchedFaces() == null ? 0 : this.unmatchedFaces().hashCode());
        hashCode = 31 * hashCode + (this.sourceImageOrientationCorrectionString() == null ? 0 : this.sourceImageOrientationCorrectionString().hashCode());
        hashCode = 31 * hashCode + (this.targetImageOrientationCorrectionString() == null ? 0 : this.targetImageOrientationCorrectionString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesResponse)) {
            return false;
        }
        CompareFacesResponse other = (CompareFacesResponse)((Object)obj);
        if (other.sourceImageFace() == null ^ this.sourceImageFace() == null) {
            return false;
        }
        if (other.sourceImageFace() != null && !other.sourceImageFace().equals(this.sourceImageFace())) {
            return false;
        }
        if (other.faceMatches() == null ^ this.faceMatches() == null) {
            return false;
        }
        if (other.faceMatches() != null && !other.faceMatches().equals(this.faceMatches())) {
            return false;
        }
        if (other.unmatchedFaces() == null ^ this.unmatchedFaces() == null) {
            return false;
        }
        if (other.unmatchedFaces() != null && !other.unmatchedFaces().equals(this.unmatchedFaces())) {
            return false;
        }
        if (other.sourceImageOrientationCorrectionString() == null ^ this.sourceImageOrientationCorrectionString() == null) {
            return false;
        }
        if (other.sourceImageOrientationCorrectionString() != null && !other.sourceImageOrientationCorrectionString().equals(this.sourceImageOrientationCorrectionString())) {
            return false;
        }
        if (other.targetImageOrientationCorrectionString() == null ^ this.targetImageOrientationCorrectionString() == null) {
            return false;
        }
        return other.targetImageOrientationCorrectionString() == null || other.targetImageOrientationCorrectionString().equals(this.targetImageOrientationCorrectionString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceImageFace() != null) {
            sb.append("SourceImageFace: ").append(this.sourceImageFace()).append(",");
        }
        if (this.faceMatches() != null) {
            sb.append("FaceMatches: ").append(this.faceMatches()).append(",");
        }
        if (this.unmatchedFaces() != null) {
            sb.append("UnmatchedFaces: ").append(this.unmatchedFaces()).append(",");
        }
        if (this.sourceImageOrientationCorrectionString() != null) {
            sb.append("SourceImageOrientationCorrection: ").append(this.sourceImageOrientationCorrectionString()).append(",");
        }
        if (this.targetImageOrientationCorrectionString() != null) {
            sb.append("TargetImageOrientationCorrection: ").append(this.targetImageOrientationCorrectionString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceImageFace": {
                return Optional.of(clazz.cast(this.sourceImageFace()));
            }
            case "FaceMatches": {
                return Optional.of(clazz.cast(this.faceMatches()));
            }
            case "UnmatchedFaces": {
                return Optional.of(clazz.cast(this.unmatchedFaces()));
            }
            case "SourceImageOrientationCorrection": {
                return Optional.of(clazz.cast(this.sourceImageOrientationCorrectionString()));
            }
            case "TargetImageOrientationCorrection": {
                return Optional.of(clazz.cast(this.targetImageOrientationCorrectionString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ComparedSourceImageFace sourceImageFace;
        private List<CompareFacesMatch> faceMatches;
        private List<ComparedFace> unmatchedFaces;
        private String sourceImageOrientationCorrection;
        private String targetImageOrientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesResponse model) {
            this.sourceImageFace(model.sourceImageFace);
            this.faceMatches(model.faceMatches);
            this.unmatchedFaces(model.unmatchedFaces);
            this.sourceImageOrientationCorrection(model.sourceImageOrientationCorrection);
            this.targetImageOrientationCorrection(model.targetImageOrientationCorrection);
        }

        public final ComparedSourceImageFace.Builder getSourceImageFace() {
            return this.sourceImageFace != null ? this.sourceImageFace.toBuilder() : null;
        }

        @Override
        public final Builder sourceImageFace(ComparedSourceImageFace sourceImageFace) {
            this.sourceImageFace = sourceImageFace;
            return this;
        }

        public final void setSourceImageFace(ComparedSourceImageFace.BuilderImpl sourceImageFace) {
            this.sourceImageFace = sourceImageFace != null ? sourceImageFace.build() : null;
        }

        public final Collection<CompareFacesMatch.Builder> getFaceMatches() {
            return this.faceMatches != null ? (Collection)this.faceMatches.stream().map(CompareFacesMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<CompareFacesMatch> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(CompareFacesMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        public final void setFaceMatches(Collection<CompareFacesMatch.BuilderImpl> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copyFromBuilder(faceMatches);
        }

        public final Collection<ComparedFace.Builder> getUnmatchedFaces() {
            return this.unmatchedFaces != null ? (Collection)this.unmatchedFaces.stream().map(ComparedFace::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copy(unmatchedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unmatchedFaces(ComparedFace ... unmatchedFaces) {
            this.unmatchedFaces(Arrays.asList(unmatchedFaces));
            return this;
        }

        public final void setUnmatchedFaces(Collection<ComparedFace.BuilderImpl> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copyFromBuilder(unmatchedFaces);
        }

        public final String getSourceImageOrientationCorrection() {
            return this.sourceImageOrientationCorrection;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection(sourceImageOrientationCorrection.toString());
            return this;
        }

        public final void setSourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
        }

        public final String getTargetImageOrientationCorrection() {
            return this.targetImageOrientationCorrection;
        }

        @Override
        public final Builder targetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder targetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection(targetImageOrientationCorrection.toString());
            return this;
        }

        public final void setTargetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
        }

        public CompareFacesResponse build() {
            return new CompareFacesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompareFacesResponse> {
        public Builder sourceImageFace(ComparedSourceImageFace var1);

        public Builder faceMatches(Collection<CompareFacesMatch> var1);

        public Builder faceMatches(CompareFacesMatch ... var1);

        public Builder unmatchedFaces(Collection<ComparedFace> var1);

        public Builder unmatchedFaces(ComparedFace ... var1);

        public Builder sourceImageOrientationCorrection(String var1);

        public Builder sourceImageOrientationCorrection(OrientationCorrection var1);

        public Builder targetImageOrientationCorrection(String var1);

        public Builder targetImageOrientationCorrection(OrientationCorrection var1);
    }
}

