/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.Smile;

public class SmileUnmarshaller
implements Unmarshaller<Smile, JsonUnmarshallerContext> {
    private static final SmileUnmarshaller INSTANCE = new SmileUnmarshaller();

    public Smile unmarshall(JsonUnmarshallerContext context) throws Exception {
        Smile.Builder smileBuilder = Smile.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    smileBuilder.value((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Confidence", targetDepth)) {
                    context.nextToken();
                    smileBuilder.confidence((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Smile)smileBuilder.build();
    }

    public static SmileUnmarshaller getInstance() {
        return INSTANCE;
    }
}

