/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.model.FaceDetailListCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectFacesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DetectFacesResponse> {
    private final List<FaceDetail> faceDetails;
    private final String orientationCorrection;

    private DetectFacesResponse(BuilderImpl builder) {
        this.faceDetails = builder.faceDetails;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public List<FaceDetail> faceDetails() {
        return this.faceDetails;
    }

    public String orientationCorrection() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.faceDetails() == null ? 0 : this.faceDetails().hashCode());
        hashCode = 31 * hashCode + (this.orientationCorrection() == null ? 0 : this.orientationCorrection().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectFacesResponse)) {
            return false;
        }
        DetectFacesResponse other = (DetectFacesResponse)((Object)obj);
        if (other.faceDetails() == null ^ this.faceDetails() == null) {
            return false;
        }
        if (other.faceDetails() != null && !other.faceDetails().equals(this.faceDetails())) {
            return false;
        }
        if (other.orientationCorrection() == null ^ this.orientationCorrection() == null) {
            return false;
        }
        return other.orientationCorrection() == null || other.orientationCorrection().equals(this.orientationCorrection());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.faceDetails() != null) {
            sb.append("FaceDetails: ").append(this.faceDetails()).append(",");
        }
        if (this.orientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(this.orientationCorrection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<FaceDetail> faceDetails;
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectFacesResponse model) {
            this.setFaceDetails(model.faceDetails);
            this.setOrientationCorrection(model.orientationCorrection);
        }

        public final Collection<FaceDetail> getFaceDetails() {
            return this.faceDetails;
        }

        @Override
        public final Builder faceDetails(Collection<FaceDetail> faceDetails) {
            this.faceDetails = FaceDetailListCopier.copy(faceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceDetails(FaceDetail ... faceDetails) {
            this.faceDetails(Arrays.asList(faceDetails));
            return this;
        }

        public final void setFaceDetails(Collection<FaceDetail> faceDetails) {
            this.faceDetails = FaceDetailListCopier.copy(faceDetails);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public DetectFacesResponse build() {
            return new DetectFacesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetectFacesResponse> {
        public Builder faceDetails(Collection<FaceDetail> var1);

        public Builder faceDetails(FaceDetail ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

