/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.FaceIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteFacesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DeleteFacesResponse> {
    private final List<String> deletedFaces;

    private DeleteFacesResponse(BuilderImpl builder) {
        this.deletedFaces = builder.deletedFaces;
    }

    public List<String> deletedFaces() {
        return this.deletedFaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deletedFaces() == null ? 0 : this.deletedFaces().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesResponse)) {
            return false;
        }
        DeleteFacesResponse other = (DeleteFacesResponse)((Object)obj);
        if (other.deletedFaces() == null ^ this.deletedFaces() == null) {
            return false;
        }
        return other.deletedFaces() == null || other.deletedFaces().equals(this.deletedFaces());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deletedFaces() != null) {
            sb.append("DeletedFaces: ").append(this.deletedFaces()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> deletedFaces;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesResponse model) {
            this.setDeletedFaces(model.deletedFaces);
        }

        public final Collection<String> getDeletedFaces() {
            return this.deletedFaces;
        }

        @Override
        public final Builder deletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedFaces(String ... deletedFaces) {
            this.deletedFaces(Arrays.asList(deletedFaces));
            return this;
        }

        public final void setDeletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
        }

        public DeleteFacesResponse build() {
            return new DeleteFacesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteFacesResponse> {
        public Builder deletedFaces(Collection<String> var1);

        public Builder deletedFaces(String ... var1);
    }
}

