/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;

@SdkInternalApi
public class ComparedFaceMarshaller {
    private static final MarshallingInfo<StructuredPojo> BOUNDINGBOX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundingBox").build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").build();
    private static final MarshallingInfo<List> LANDMARKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Landmarks").build();
    private static final MarshallingInfo<StructuredPojo> POSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pose").build();
    private static final MarshallingInfo<StructuredPojo> QUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Quality").build();
    private static final ComparedFaceMarshaller instance = new ComparedFaceMarshaller();

    public static ComparedFaceMarshaller getInstance() {
        return instance;
    }

    public void marshall(ComparedFace comparedFace, ProtocolMarshaller protocolMarshaller) {
        if (comparedFace == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)comparedFace.boundingBox(), BOUNDINGBOX_BINDING);
            protocolMarshaller.marshall((Object)comparedFace.confidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall(comparedFace.landmarks(), LANDMARKS_BINDING);
            protocolMarshaller.marshall((Object)comparedFace.pose(), POSE_BINDING);
            protocolMarshaller.marshall((Object)comparedFace.quality(), QUALITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

