/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse;

public class GetFaceSearchPublisher
implements SdkPublisher<GetFaceSearchResponse> {
    private final RekognitionAsyncClient client;
    private final GetFaceSearchRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFaceSearchPublisher(RekognitionAsyncClient client, GetFaceSearchRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFaceSearchPublisher(RekognitionAsyncClient client, GetFaceSearchRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFaceSearchResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFaceSearchResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetFaceSearchPublisher resume(GetFaceSearchResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetFaceSearchPublisher(this.client, (GetFaceSearchRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetFaceSearchPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetFaceSearchResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetFaceSearchResponseFetcher
    implements AsyncPageFetcher<GetFaceSearchResponse> {
        private GetFaceSearchResponseFetcher() {
        }

        public boolean hasNextPage(GetFaceSearchResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFaceSearchResponse> nextPage(GetFaceSearchResponse previousPage) {
            if (previousPage == null) {
                return GetFaceSearchPublisher.this.client.getFaceSearch(GetFaceSearchPublisher.this.firstRequest);
            }
            return GetFaceSearchPublisher.this.client.getFaceSearch((GetFaceSearchRequest)((Object)GetFaceSearchPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

