/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.Pose;

@SdkInternalApi
public class PoseMarshaller {
    private static final MarshallingInfo<Float> ROLL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Roll").build();
    private static final MarshallingInfo<Float> YAW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Yaw").build();
    private static final MarshallingInfo<Float> PITCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pitch").build();
    private static final PoseMarshaller instance = new PoseMarshaller();

    public static PoseMarshaller getInstance() {
        return instance;
    }

    public void marshall(Pose pose, ProtocolMarshaller protocolMarshaller) {
        if (pose == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)pose.roll(), ROLL_BINDING);
            protocolMarshaller.marshall((Object)pose.yaw(), YAW_BINDING);
            protocolMarshaller.marshall((Object)pose.pitch(), PITCH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

