/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.ImageQuality;

@SdkInternalApi
public class ImageQualityMarshaller {
    private static final MarshallingInfo<Float> BRIGHTNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Brightness").build();
    private static final MarshallingInfo<Float> SHARPNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sharpness").build();
    private static final ImageQualityMarshaller instance = new ImageQualityMarshaller();

    public static ImageQualityMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageQuality imageQuality, ProtocolMarshaller protocolMarshaller) {
        if (imageQuality == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageQuality.brightness(), BRIGHTNESS_BINDING);
            protocolMarshaller.marshall((Object)imageQuality.sharpness(), SHARPNESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

