/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.CompareFacesMatch;
import software.amazon.awssdk.services.rekognition.model.CompareFacesMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.CompareFacesUnmatchListCopier;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.ComparedSourceImageFace;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompareFacesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CompareFacesResponse> {
    private final ComparedSourceImageFace sourceImageFace;
    private final List<CompareFacesMatch> faceMatches;
    private final List<ComparedFace> unmatchedFaces;
    private final String sourceImageOrientationCorrection;
    private final String targetImageOrientationCorrection;

    private CompareFacesResponse(BuilderImpl builder) {
        this.sourceImageFace = builder.sourceImageFace;
        this.faceMatches = builder.faceMatches;
        this.unmatchedFaces = builder.unmatchedFaces;
        this.sourceImageOrientationCorrection = builder.sourceImageOrientationCorrection;
        this.targetImageOrientationCorrection = builder.targetImageOrientationCorrection;
    }

    public ComparedSourceImageFace sourceImageFace() {
        return this.sourceImageFace;
    }

    public List<CompareFacesMatch> faceMatches() {
        return this.faceMatches;
    }

    public List<ComparedFace> unmatchedFaces() {
        return this.unmatchedFaces;
    }

    public String sourceImageOrientationCorrection() {
        return this.sourceImageOrientationCorrection;
    }

    public String targetImageOrientationCorrection() {
        return this.targetImageOrientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceImageFace() == null ? 0 : this.sourceImageFace().hashCode());
        hashCode = 31 * hashCode + (this.faceMatches() == null ? 0 : this.faceMatches().hashCode());
        hashCode = 31 * hashCode + (this.unmatchedFaces() == null ? 0 : this.unmatchedFaces().hashCode());
        hashCode = 31 * hashCode + (this.sourceImageOrientationCorrection() == null ? 0 : this.sourceImageOrientationCorrection().hashCode());
        hashCode = 31 * hashCode + (this.targetImageOrientationCorrection() == null ? 0 : this.targetImageOrientationCorrection().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesResponse)) {
            return false;
        }
        CompareFacesResponse other = (CompareFacesResponse)((Object)obj);
        if (other.sourceImageFace() == null ^ this.sourceImageFace() == null) {
            return false;
        }
        if (other.sourceImageFace() != null && !other.sourceImageFace().equals(this.sourceImageFace())) {
            return false;
        }
        if (other.faceMatches() == null ^ this.faceMatches() == null) {
            return false;
        }
        if (other.faceMatches() != null && !other.faceMatches().equals(this.faceMatches())) {
            return false;
        }
        if (other.unmatchedFaces() == null ^ this.unmatchedFaces() == null) {
            return false;
        }
        if (other.unmatchedFaces() != null && !other.unmatchedFaces().equals(this.unmatchedFaces())) {
            return false;
        }
        if (other.sourceImageOrientationCorrection() == null ^ this.sourceImageOrientationCorrection() == null) {
            return false;
        }
        if (other.sourceImageOrientationCorrection() != null && !other.sourceImageOrientationCorrection().equals(this.sourceImageOrientationCorrection())) {
            return false;
        }
        if (other.targetImageOrientationCorrection() == null ^ this.targetImageOrientationCorrection() == null) {
            return false;
        }
        return other.targetImageOrientationCorrection() == null || other.targetImageOrientationCorrection().equals(this.targetImageOrientationCorrection());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceImageFace() != null) {
            sb.append("SourceImageFace: ").append(this.sourceImageFace()).append(",");
        }
        if (this.faceMatches() != null) {
            sb.append("FaceMatches: ").append(this.faceMatches()).append(",");
        }
        if (this.unmatchedFaces() != null) {
            sb.append("UnmatchedFaces: ").append(this.unmatchedFaces()).append(",");
        }
        if (this.sourceImageOrientationCorrection() != null) {
            sb.append("SourceImageOrientationCorrection: ").append(this.sourceImageOrientationCorrection()).append(",");
        }
        if (this.targetImageOrientationCorrection() != null) {
            sb.append("TargetImageOrientationCorrection: ").append(this.targetImageOrientationCorrection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ComparedSourceImageFace sourceImageFace;
        private List<CompareFacesMatch> faceMatches;
        private List<ComparedFace> unmatchedFaces;
        private String sourceImageOrientationCorrection;
        private String targetImageOrientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesResponse model) {
            this.setSourceImageFace(model.sourceImageFace);
            this.setFaceMatches(model.faceMatches);
            this.setUnmatchedFaces(model.unmatchedFaces);
            this.setSourceImageOrientationCorrection(model.sourceImageOrientationCorrection);
            this.setTargetImageOrientationCorrection(model.targetImageOrientationCorrection);
        }

        public final ComparedSourceImageFace getSourceImageFace() {
            return this.sourceImageFace;
        }

        @Override
        public final Builder sourceImageFace(ComparedSourceImageFace sourceImageFace) {
            this.sourceImageFace = sourceImageFace;
            return this;
        }

        public final void setSourceImageFace(ComparedSourceImageFace sourceImageFace) {
            this.sourceImageFace = sourceImageFace;
        }

        public final Collection<CompareFacesMatch> getFaceMatches() {
            return this.faceMatches;
        }

        @Override
        public final Builder faceMatches(Collection<CompareFacesMatch> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(CompareFacesMatch ... faceMatches) {
            if (this.faceMatches == null) {
                this.faceMatches = new ArrayList<CompareFacesMatch>(faceMatches.length);
            }
            for (CompareFacesMatch e : faceMatches) {
                this.faceMatches.add(e);
            }
            return this;
        }

        public final void setFaceMatches(Collection<CompareFacesMatch> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copy(faceMatches);
        }

        @SafeVarargs
        public final void setFaceMatches(CompareFacesMatch ... faceMatches) {
            if (this.faceMatches == null) {
                this.faceMatches = new ArrayList<CompareFacesMatch>(faceMatches.length);
            }
            for (CompareFacesMatch e : faceMatches) {
                this.faceMatches.add(e);
            }
        }

        public final Collection<ComparedFace> getUnmatchedFaces() {
            return this.unmatchedFaces;
        }

        @Override
        public final Builder unmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copy(unmatchedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unmatchedFaces(ComparedFace ... unmatchedFaces) {
            if (this.unmatchedFaces == null) {
                this.unmatchedFaces = new ArrayList<ComparedFace>(unmatchedFaces.length);
            }
            for (ComparedFace e : unmatchedFaces) {
                this.unmatchedFaces.add(e);
            }
            return this;
        }

        public final void setUnmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copy(unmatchedFaces);
        }

        @SafeVarargs
        public final void setUnmatchedFaces(ComparedFace ... unmatchedFaces) {
            if (this.unmatchedFaces == null) {
                this.unmatchedFaces = new ArrayList<ComparedFace>(unmatchedFaces.length);
            }
            for (ComparedFace e : unmatchedFaces) {
                this.unmatchedFaces.add(e);
            }
        }

        public final String getSourceImageOrientationCorrection() {
            return this.sourceImageOrientationCorrection;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection(sourceImageOrientationCorrection.toString());
            return this;
        }

        public final void setSourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
        }

        public final void setSourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection(sourceImageOrientationCorrection.toString());
        }

        public final String getTargetImageOrientationCorrection() {
            return this.targetImageOrientationCorrection;
        }

        @Override
        public final Builder targetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder targetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection(targetImageOrientationCorrection.toString());
            return this;
        }

        public final void setTargetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
        }

        public final void setTargetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection(targetImageOrientationCorrection.toString());
        }

        public CompareFacesResponse build() {
            return new CompareFacesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompareFacesResponse> {
        public Builder sourceImageFace(ComparedSourceImageFace var1);

        public Builder faceMatches(Collection<CompareFacesMatch> var1);

        public Builder faceMatches(CompareFacesMatch ... var1);

        public Builder unmatchedFaces(Collection<ComparedFace> var1);

        public Builder unmatchedFaces(ComparedFace ... var1);

        public Builder sourceImageOrientationCorrection(String var1);

        public Builder sourceImageOrientationCorrection(OrientationCorrection var1);

        public Builder targetImageOrientationCorrection(String var1);

        public Builder targetImageOrientationCorrection(OrientationCorrection var1);
    }
}

