/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class OrganizationsServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "organizations";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put((Object)"aws-global", (Object)"organizations.us-east-1.amazonaws.com").put((Object)"fips-aws-global", (Object)"organizations-fips.us-east-1.amazonaws.com").put((Object)"aws-us-gov-global", (Object)"organizations.us-gov-west-1.amazonaws.com").put((Object)"fips-aws-us-gov-global", (Object)"organizations.us-gov-west-1.amazonaws.com").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("aws-global"), Region.of("fips-aws-global"), Region.of("aws-us-gov-global"), Region.of("fips-aws-us-gov-global")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put((Object)"aws-global", (Object)"us-east-1").put((Object)"fips-aws-global", (Object)"us-east-1").put((Object)"aws-us-gov-global", (Object)"us-gov-west-1").put((Object)"fips-aws-us-gov-global", (Object)"us-gov-west-1").build();
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", Region.of("aws-global")), new DefaultServicePartitionMetadata("aws-us-gov", Region.of("aws-us-gov-global"))));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}

