/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class PortalSsoServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "portal.sso";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put((Object)"ap-southeast-1", (Object)"portal.sso.ap-southeast-1.amazonaws.com").put((Object)"ap-southeast-2", (Object)"portal.sso.ap-southeast-2.amazonaws.com").put((Object)"ca-central-1", (Object)"portal.sso.ca-central-1.amazonaws.com").put((Object)"eu-central-1", (Object)"portal.sso.eu-central-1.amazonaws.com").put((Object)"eu-west-1", (Object)"portal.sso.eu-west-1.amazonaws.com").put((Object)"eu-west-2", (Object)"portal.sso.eu-west-2.amazonaws.com").put((Object)"us-east-1", (Object)"portal.sso.us-east-1.amazonaws.com").put((Object)"us-east-2", (Object)"portal.sso.us-east-2.amazonaws.com").put((Object)"us-west-2", (Object)"portal.sso.us-west-2.amazonaws.com").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-2")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put((Object)"ap-southeast-1", (Object)"ap-southeast-1").put((Object)"ap-southeast-2", (Object)"ap-southeast-2").put((Object)"ca-central-1", (Object)"ca-central-1").put((Object)"eu-central-1", (Object)"eu-central-1").put((Object)"eu-west-1", (Object)"eu-west-1").put((Object)"eu-west-2", (Object)"eu-west-2").put((Object)"us-east-1", (Object)"us-east-1").put((Object)"us-east-2", (Object)"us-east-2").put((Object)"us-west-2", (Object)"us-west-2").build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }
}

