/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
@ReviewBeforeRelease(value="Refactor to use SDK HTTP client instead of URL connection, also consider putting EC2MetadataClient into its own module")
class ConnectionUtils {
    ConnectionUtils() {
    }

    static ConnectionUtils create() {
        return new ConnectionUtils();
    }

    HttpURLConnection connectToEndpoint(URI endpoint, Map<String, String> headers) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)endpoint.toURL().openConnection(Proxy.NO_PROXY);
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        headers.forEach(connection::addRequestProperty);
        connection.setInstanceFollowRedirects(false);
        connection.connect();
        return connection;
    }
}

