/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.providers;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.internal.model.CredentialScope;
import software.amazon.awssdk.regions.internal.model.Endpoint;
import software.amazon.awssdk.regions.internal.model.Partition;
import software.amazon.awssdk.regions.internal.model.Service;

public class PartitionServiceMetadata
implements ServiceMetadata {
    private static final String SERVICE = "{service}";
    private static final String REGION = "{region}";
    private static final String DNS_SUFFIX = "{dnsSuffix}";
    private final String service;
    private final Map<String, Partition> servicePartitionData;

    public PartitionServiceMetadata(String service, Map<String, Partition> servicePartitionData) {
        this.service = service;
        this.servicePartitionData = servicePartitionData;
    }

    @Override
    public URI endpointFor(Region region) {
        RegionMetadata regionMetadata = RegionMetadata.of(region);
        Endpoint endpoint = this.computeEndpoint(this.service, region);
        return URI.create(endpoint.getHostname().replace(SERVICE, this.service).replace(REGION, region.value()).replace(DNS_SUFFIX, regionMetadata.getDomain()));
    }

    @Override
    public Region signingRegion(Region region) {
        CredentialScope credentialScope = this.computeEndpoint(this.service, region).getCredentialScope();
        return Region.of(credentialScope != null && credentialScope.getRegion() != null ? credentialScope.getRegion() : region.value());
    }

    private Endpoint computeEndpoint(String serviceName, Region region) {
        RegionMetadata regionMetadata = RegionMetadata.of(region);
        Partition partitionData = this.servicePartitionData.get(regionMetadata.getPartition());
        Service service = partitionData.getServices().get(serviceName);
        return partitionData.getDefaults().merge(service != null ? service.getDefaults() : null).merge(service != null && service.getEndpoints() != null ? service.getEndpoints().get(region.value()) : null);
    }

    @Override
    public List<Region> regions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        this.servicePartitionData.entrySet().stream().forEach(p -> {
            Service serviceData = ((Partition)p.getValue()).getServices().get(this.service);
            if (serviceData != null) {
                serviceData.getEndpoints().keySet().stream().forEach(r -> regions.add(Region.of(r)));
            }
        });
        return regions;
    }
}

