/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.providers;

import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.util.EC2MetadataUtils;

public class InstanceProfileRegionProvider
implements AwsRegionProvider {
    private volatile String region;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getRegion() throws SdkClientException {
        if (this.region == null) {
            InstanceProfileRegionProvider instanceProfileRegionProvider = this;
            synchronized (instanceProfileRegionProvider) {
                if (this.region == null) {
                    this.region = this.tryDetectRegion();
                }
            }
        }
        return this.region == null ? null : Region.of(this.region);
    }

    private String tryDetectRegion() {
        try {
            return EC2MetadataUtils.getEC2InstanceRegion();
        }
        catch (SdkClientException sce) {
            LoggerFactory.getLogger(InstanceProfileRegionProvider.class).debug("Ignoring failure to retrieve the region: {}", (Object)sce.getMessage());
            return null;
        }
    }
}

