/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a track that determines which Amazon Redshift version to apply after a new version is released. If the value
 * for <code>ServerlessTrack</code> is <code>current</code>, the workgroup is updated to the most recently certified
 * release. If the value is <code>trailing</code>, the workgroup is updated to the previously certified release.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerlessTrack implements SdkPojo, Serializable, ToCopyableBuilder<ServerlessTrack.Builder, ServerlessTrack> {
    private static final SdkField<String> TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackName").getter(getter(ServerlessTrack::trackName)).setter(setter(Builder::trackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackName").build()).build();

    private static final SdkField<List<UpdateTarget>> UPDATE_TARGETS_FIELD = SdkField
            .<List<UpdateTarget>> builder(MarshallingType.LIST)
            .memberName("updateTargets")
            .getter(getter(ServerlessTrack::updateTargets))
            .setter(setter(Builder::updateTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKGROUP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupVersion").getter(getter(ServerlessTrack::workgroupVersion))
            .setter(setter(Builder::workgroupVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACK_NAME_FIELD,
            UPDATE_TARGETS_FIELD, WORKGROUP_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trackName;

    private final List<UpdateTarget> updateTargets;

    private final String workgroupVersion;

    private ServerlessTrack(BuilderImpl builder) {
        this.trackName = builder.trackName;
        this.updateTargets = builder.updateTargets;
        this.workgroupVersion = builder.workgroupVersion;
    }

    /**
     * <p>
     * The name of the track. Valid values are <code>current</code> and <code>trailing</code>.
     * </p>
     * 
     * @return The name of the track. Valid values are <code>current</code> and <code>trailing</code>.
     */
    public final String trackName() {
        return trackName;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdateTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUpdateTargets() {
        return updateTargets != null && !(updateTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>UpdateTarget</code> objects to update with the track.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateTargets} method.
     * </p>
     * 
     * @return An array of <code>UpdateTarget</code> objects to update with the track.
     */
    public final List<UpdateTarget> updateTargets() {
        return updateTargets;
    }

    /**
     * <p>
     * The workgroup version number for the workgroup release.
     * </p>
     * 
     * @return The workgroup version number for the workgroup release.
     */
    public final String workgroupVersion() {
        return workgroupVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trackName());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdateTargets() ? updateTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workgroupVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessTrack)) {
            return false;
        }
        ServerlessTrack other = (ServerlessTrack) obj;
        return Objects.equals(trackName(), other.trackName()) && hasUpdateTargets() == other.hasUpdateTargets()
                && Objects.equals(updateTargets(), other.updateTargets())
                && Objects.equals(workgroupVersion(), other.workgroupVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerlessTrack").add("TrackName", trackName())
                .add("UpdateTargets", hasUpdateTargets() ? updateTargets() : null).add("WorkgroupVersion", workgroupVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trackName":
            return Optional.ofNullable(clazz.cast(trackName()));
        case "updateTargets":
            return Optional.ofNullable(clazz.cast(updateTargets()));
        case "workgroupVersion":
            return Optional.ofNullable(clazz.cast(workgroupVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trackName", TRACK_NAME_FIELD);
        map.put("updateTargets", UPDATE_TARGETS_FIELD);
        map.put("workgroupVersion", WORKGROUP_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessTrack, T> g) {
        return obj -> g.apply((ServerlessTrack) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerlessTrack> {
        /**
         * <p>
         * The name of the track. Valid values are <code>current</code> and <code>trailing</code>.
         * </p>
         * 
         * @param trackName
         *        The name of the track. Valid values are <code>current</code> and <code>trailing</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackName(String trackName);

        /**
         * <p>
         * An array of <code>UpdateTarget</code> objects to update with the track.
         * </p>
         * 
         * @param updateTargets
         *        An array of <code>UpdateTarget</code> objects to update with the track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTargets(Collection<UpdateTarget> updateTargets);

        /**
         * <p>
         * An array of <code>UpdateTarget</code> objects to update with the track.
         * </p>
         * 
         * @param updateTargets
         *        An array of <code>UpdateTarget</code> objects to update with the track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTargets(UpdateTarget... updateTargets);

        /**
         * <p>
         * An array of <code>UpdateTarget</code> objects to update with the track.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateTarget.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #updateTargets(List<UpdateTarget>)}.
         * 
         * @param updateTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.UpdateTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateTargets(java.util.Collection<UpdateTarget>)
         */
        Builder updateTargets(Consumer<UpdateTarget.Builder>... updateTargets);

        /**
         * <p>
         * The workgroup version number for the workgroup release.
         * </p>
         * 
         * @param workgroupVersion
         *        The workgroup version number for the workgroup release.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupVersion(String workgroupVersion);
    }

    static final class BuilderImpl implements Builder {
        private String trackName;

        private List<UpdateTarget> updateTargets = DefaultSdkAutoConstructList.getInstance();

        private String workgroupVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessTrack model) {
            trackName(model.trackName);
            updateTargets(model.updateTargets);
            workgroupVersion(model.workgroupVersion);
        }

        public final String getTrackName() {
            return trackName;
        }

        public final void setTrackName(String trackName) {
            this.trackName = trackName;
        }

        @Override
        public final Builder trackName(String trackName) {
            this.trackName = trackName;
            return this;
        }

        public final List<UpdateTarget.Builder> getUpdateTargets() {
            List<UpdateTarget.Builder> result = UpdateTargetsListCopier.copyToBuilder(this.updateTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateTargets(Collection<UpdateTarget.BuilderImpl> updateTargets) {
            this.updateTargets = UpdateTargetsListCopier.copyFromBuilder(updateTargets);
        }

        @Override
        public final Builder updateTargets(Collection<UpdateTarget> updateTargets) {
            this.updateTargets = UpdateTargetsListCopier.copy(updateTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(UpdateTarget... updateTargets) {
            updateTargets(Arrays.asList(updateTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(Consumer<UpdateTarget.Builder>... updateTargets) {
            updateTargets(Stream.of(updateTargets).map(c -> UpdateTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getWorkgroupVersion() {
            return workgroupVersion;
        }

        public final void setWorkgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
        }

        @Override
        public final Builder workgroupVersion(String workgroupVersion) {
            this.workgroupVersion = workgroupVersion;
            return this;
        }

        @Override
        public ServerlessTrack build() {
            return new ServerlessTrack(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
