/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<CreateSnapshotRequest.Builder, CreateSnapshotRequest> {
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(CreateSnapshotRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionPeriod").getter(getter(CreateSnapshotRequest::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotName").getter(getter(CreateSnapshotRequest::snapshotName)).setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_NAME_FIELD,
            RETENTION_PERIOD_FIELD, SNAPSHOT_NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String namespaceName;

    private final Integer retentionPeriod;

    private final String snapshotName;

    private final List<Tag> tags;

    private CreateSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.namespaceName = builder.namespaceName;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotName = builder.snapshotName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The namespace to create a snapshot for.
     * </p>
     * 
     * @return The namespace to create a snapshot for.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * How long to retain the created snapshot.
     * </p>
     * 
     * @return How long to retain the created snapshot.
     */
    public final Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * The name of the snapshot.
     * </p>
     * 
     * @return The name of the snapshot.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
     * objects</a> to associate with the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of <a
     *         href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag objects</a>
     *         to associate with the snapshot.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest) obj;
        return Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(snapshotName(), other.snapshotName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSnapshotRequest").add("NamespaceName", namespaceName())
                .add("RetentionPeriod", retentionPeriod()).add("SnapshotName", snapshotName())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "snapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("retentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("snapshotName", SNAPSHOT_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotRequest, T> g) {
        return obj -> g.apply((CreateSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSnapshotRequest> {
        /**
         * <p>
         * The namespace to create a snapshot for.
         * </p>
         * 
         * @param namespaceName
         *        The namespace to create a snapshot for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * How long to retain the created snapshot.
         * </p>
         * 
         * @param retentionPeriod
         *        How long to retain the created snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * The name of the snapshot.
         * </p>
         * 
         * @param snapshotName
         *        The name of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         * objects</a> to associate with the snapshot.
         * </p>
         * 
         * @param tags
         *        An array of <a
         *        href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         *        objects</a> to associate with the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         * objects</a> to associate with the snapshot.
         * </p>
         * 
         * @param tags
         *        An array of <a
         *        href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         *        objects</a> to associate with the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         * objects</a> to associate with the snapshot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.redshiftserverless.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private String namespaceName;

        private Integer retentionPeriod;

        private String snapshotName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotRequest model) {
            super(model);
            namespaceName(model.namespaceName);
            retentionPeriod(model.retentionPeriod);
            snapshotName(model.snapshotName);
            tags(model.tags);
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotRequest build() {
            return new CreateSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
