/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.ReservationOffering;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Reservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Reservation> {
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("capacity").getter(Reservation.getter(Reservation::capacity)).setter(Reservation.setter(Builder::capacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDate").getter(Reservation.getter(Reservation::endDate)).setter(Reservation.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ReservationOffering> OFFERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("offering").getter(Reservation.getter(Reservation::offering)).setter(Reservation.setter(Builder::offering)).constructor(ReservationOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offering").build()}).build();
    private static final SdkField<String> RESERVATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reservationArn").getter(Reservation.getter(Reservation::reservationArn)).setter(Reservation.setter(Builder::reservationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationArn").build()}).build();
    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reservationId").getter(Reservation.getter(Reservation::reservationId)).setter(Reservation.setter(Builder::reservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationId").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(Reservation.getter(Reservation::startDate)).setter(Reservation.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Reservation.getter(Reservation::status)).setter(Reservation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD, END_DATE_FIELD, OFFERING_FIELD, RESERVATION_ARN_FIELD, RESERVATION_ID_FIELD, START_DATE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Reservation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer capacity;
    private final Instant endDate;
    private final ReservationOffering offering;
    private final String reservationArn;
    private final String reservationId;
    private final Instant startDate;
    private final String status;

    private Reservation(BuilderImpl builder) {
        this.capacity = builder.capacity;
        this.endDate = builder.endDate;
        this.offering = builder.offering;
        this.reservationArn = builder.reservationArn;
        this.reservationId = builder.reservationId;
        this.startDate = builder.startDate;
        this.status = builder.status;
    }

    public final Integer capacity() {
        return this.capacity;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final ReservationOffering offering() {
        return this.offering;
    }

    public final String reservationArn() {
        return this.reservationArn;
    }

    public final String reservationId() {
        return this.reservationId;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.offering());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation)obj;
        return Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.offering(), other.offering()) && Objects.equals(this.reservationArn(), other.reservationArn()) && Objects.equals(this.reservationId(), other.reservationId()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"Reservation").add("Capacity", (Object)this.capacity()).add("EndDate", (Object)this.endDate()).add("Offering", (Object)this.offering()).add("ReservationArn", (Object)this.reservationArn()).add("ReservationId", (Object)this.reservationId()).add("StartDate", (Object)this.startDate()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "endDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "offering": {
                return Optional.ofNullable(clazz.cast(this.offering()));
            }
            case "reservationArn": {
                return Optional.ofNullable(clazz.cast(this.reservationArn()));
            }
            case "reservationId": {
                return Optional.ofNullable(clazz.cast(this.reservationId()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("capacity", CAPACITY_FIELD);
        map.put("endDate", END_DATE_FIELD);
        map.put("offering", OFFERING_FIELD);
        map.put("reservationArn", RESERVATION_ARN_FIELD);
        map.put("reservationId", RESERVATION_ID_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Reservation, T> g) {
        return obj -> g.apply((Reservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer capacity;
        private Instant endDate;
        private ReservationOffering offering;
        private String reservationArn;
        private String reservationId;
        private Instant startDate;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            this.capacity(model.capacity);
            this.endDate(model.endDate);
            this.offering(model.offering);
            this.reservationArn(model.reservationArn);
            this.reservationId(model.reservationId);
            this.startDate(model.startDate);
            this.status(model.status);
        }

        public final Integer getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final ReservationOffering.Builder getOffering() {
            return this.offering != null ? this.offering.toBuilder() : null;
        }

        public final void setOffering(ReservationOffering.BuilderImpl offering) {
            this.offering = offering != null ? offering.build() : null;
        }

        @Override
        public final Builder offering(ReservationOffering offering) {
            this.offering = offering;
            return this;
        }

        public final String getReservationArn() {
            return this.reservationArn;
        }

        public final void setReservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
        }

        @Override
        public final Builder reservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
            return this;
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public Reservation build() {
            return new Reservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Reservation> {
        public Builder capacity(Integer var1);

        public Builder endDate(Instant var1);

        public Builder offering(ReservationOffering var1);

        default public Builder offering(Consumer<ReservationOffering.Builder> offering) {
            return this.offering((ReservationOffering)((ReservationOffering.Builder)ReservationOffering.builder().applyMutation(offering)).build());
        }

        public Builder reservationArn(String var1);

        public Builder reservationId(String var1);

        public Builder startDate(Instant var1);

        public Builder status(String var1);
    }
}

