/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCredentialsResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, GetCredentialsResponse> {
    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbPassword").getter(GetCredentialsResponse.getter(GetCredentialsResponse::dbPassword)).setter(GetCredentialsResponse.setter(Builder::dbPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbPassword").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbUser").getter(GetCredentialsResponse.getter(GetCredentialsResponse::dbUser)).setter(GetCredentialsResponse.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbUser").build()}).build();
    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiration").getter(GetCredentialsResponse.getter(GetCredentialsResponse::expiration)).setter(GetCredentialsResponse.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()}).build();
    private static final SdkField<Instant> NEXT_REFRESH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("nextRefreshTime").getter(GetCredentialsResponse.getter(GetCredentialsResponse::nextRefreshTime)).setter(GetCredentialsResponse.setter(Builder::nextRefreshTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextRefreshTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PASSWORD_FIELD, DB_USER_FIELD, EXPIRATION_FIELD, NEXT_REFRESH_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCredentialsResponse.memberNameToFieldInitializer();
    private final String dbPassword;
    private final String dbUser;
    private final Instant expiration;
    private final Instant nextRefreshTime;

    private GetCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.dbPassword = builder.dbPassword;
        this.dbUser = builder.dbUser;
        this.expiration = builder.expiration;
        this.nextRefreshTime = builder.nextRefreshTime;
    }

    public final String dbPassword() {
        return this.dbPassword;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final Instant expiration() {
        return this.expiration;
    }

    public final Instant nextRefreshTime() {
        return this.nextRefreshTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextRefreshTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCredentialsResponse)) {
            return false;
        }
        GetCredentialsResponse other = (GetCredentialsResponse)((Object)obj);
        return Objects.equals(this.dbPassword(), other.dbPassword()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.expiration(), other.expiration()) && Objects.equals(this.nextRefreshTime(), other.nextRefreshTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetCredentialsResponse").add("DbPassword", (Object)(this.dbPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("DbUser", (Object)(this.dbUser() == null ? null : "*** Sensitive Data Redacted ***")).add("Expiration", (Object)this.expiration()).add("NextRefreshTime", (Object)this.nextRefreshTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbPassword": {
                return Optional.ofNullable(clazz.cast(this.dbPassword()));
            }
            case "dbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
            case "nextRefreshTime": {
                return Optional.ofNullable(clazz.cast(this.nextRefreshTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dbPassword", DB_PASSWORD_FIELD);
        map.put("dbUser", DB_USER_FIELD);
        map.put("expiration", EXPIRATION_FIELD);
        map.put("nextRefreshTime", NEXT_REFRESH_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCredentialsResponse, T> g) {
        return obj -> g.apply((GetCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private String dbPassword;
        private String dbUser;
        private Instant expiration;
        private Instant nextRefreshTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCredentialsResponse model) {
            super(model);
            this.dbPassword(model.dbPassword);
            this.dbUser(model.dbUser);
            this.expiration(model.expiration);
            this.nextRefreshTime(model.nextRefreshTime);
        }

        public final String getDbPassword() {
            return this.dbPassword;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final Instant getNextRefreshTime() {
            return this.nextRefreshTime;
        }

        public final void setNextRefreshTime(Instant nextRefreshTime) {
            this.nextRefreshTime = nextRefreshTime;
        }

        @Override
        public final Builder nextRefreshTime(Instant nextRefreshTime) {
            this.nextRefreshTime = nextRefreshTime;
            return this;
        }

        @Override
        public GetCredentialsResponse build() {
            return new GetCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCredentialsResponse> {
        public Builder dbPassword(String var1);

        public Builder dbUser(String var1);

        public Builder expiration(Instant var1);

        public Builder nextRefreshTime(Instant var1);
    }
}

