/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ScheduledActionAssociation;
import software.amazon.awssdk.services.redshiftserverless.model.ScheduledActionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScheduledActionsResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, ListScheduledActionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListScheduledActionsResponse.getter(ListScheduledActionsResponse::nextToken)).setter(ListScheduledActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ScheduledActionAssociation>> SCHEDULED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scheduledActions").getter(ListScheduledActionsResponse.getter(ListScheduledActionsResponse::scheduledActions)).setter(ListScheduledActionsResponse.setter(Builder::scheduledActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledActionAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEDULED_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListScheduledActionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ScheduledActionAssociation> scheduledActions;

    private ListScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduledActions = builder.scheduledActions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasScheduledActions() {
        return this.scheduledActions != null && !(this.scheduledActions instanceof SdkAutoConstructList);
    }

    public final List<ScheduledActionAssociation> scheduledActions() {
        return this.scheduledActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledActions() ? this.scheduledActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduledActionsResponse)) {
            return false;
        }
        ListScheduledActionsResponse other = (ListScheduledActionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasScheduledActions() == other.hasScheduledActions() && Objects.equals(this.scheduledActions(), other.scheduledActions());
    }

    public final String toString() {
        return ToString.builder((String)"ListScheduledActionsResponse").add("NextToken", (Object)this.nextToken()).add("ScheduledActions", this.hasScheduledActions() ? this.scheduledActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "scheduledActions": {
                return Optional.ofNullable(clazz.cast(this.scheduledActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("scheduledActions", SCHEDULED_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScheduledActionsResponse, T> g) {
        return obj -> g.apply((ListScheduledActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduledActionAssociation> scheduledActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduledActionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.scheduledActions(model.scheduledActions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScheduledActionAssociation.Builder> getScheduledActions() {
            List<ScheduledActionAssociation.Builder> result = ScheduledActionsListCopier.copyToBuilder(this.scheduledActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledActions(Collection<ScheduledActionAssociation.BuilderImpl> scheduledActions) {
            this.scheduledActions = ScheduledActionsListCopier.copyFromBuilder(scheduledActions);
        }

        @Override
        public final Builder scheduledActions(Collection<ScheduledActionAssociation> scheduledActions) {
            this.scheduledActions = ScheduledActionsListCopier.copy(scheduledActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(ScheduledActionAssociation ... scheduledActions) {
            this.scheduledActions(Arrays.asList(scheduledActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(Consumer<ScheduledActionAssociation.Builder> ... scheduledActions) {
            this.scheduledActions(Stream.of(scheduledActions).map(c -> (ScheduledActionAssociation)((ScheduledActionAssociation.Builder)ScheduledActionAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScheduledActionsResponse build() {
            return new ListScheduledActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScheduledActionsResponse> {
        public Builder nextToken(String var1);

        public Builder scheduledActions(Collection<ScheduledActionAssociation> var1);

        public Builder scheduledActions(ScheduledActionAssociation ... var1);

        public Builder scheduledActions(Consumer<ScheduledActionAssociation.Builder> ... var1);
    }
}

