/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ServerlessTrack;
import software.amazon.awssdk.services.redshiftserverless.model.TrackListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTracksResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, ListTracksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTracksResponse.getter(ListTracksResponse::nextToken)).setter(ListTracksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ServerlessTrack>> TRACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tracks").getter(ListTracksResponse.getter(ListTracksResponse::tracks)).setter(ListTracksResponse.setter(Builder::tracks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerlessTrack::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TRACKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTracksResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ServerlessTrack> tracks;

    private ListTracksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.tracks = builder.tracks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTracks() {
        return this.tracks != null && !(this.tracks instanceof SdkAutoConstructList);
    }

    public final List<ServerlessTrack> tracks() {
        return this.tracks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTracks() ? this.tracks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTracksResponse)) {
            return false;
        }
        ListTracksResponse other = (ListTracksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTracks() == other.hasTracks() && Objects.equals(this.tracks(), other.tracks());
    }

    public final String toString() {
        return ToString.builder((String)"ListTracksResponse").add("NextToken", (Object)this.nextToken()).add("Tracks", this.hasTracks() ? this.tracks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "tracks": {
                return Optional.ofNullable(clazz.cast(this.tracks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("tracks", TRACKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTracksResponse, T> g) {
        return obj -> g.apply((ListTracksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServerlessTrack> tracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTracksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.tracks(model.tracks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServerlessTrack.Builder> getTracks() {
            List<ServerlessTrack.Builder> result = TrackListCopier.copyToBuilder(this.tracks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTracks(Collection<ServerlessTrack.BuilderImpl> tracks) {
            this.tracks = TrackListCopier.copyFromBuilder(tracks);
        }

        @Override
        public final Builder tracks(Collection<ServerlessTrack> tracks) {
            this.tracks = TrackListCopier.copy(tracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(ServerlessTrack ... tracks) {
            this.tracks(Arrays.asList(tracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Consumer<ServerlessTrack.Builder> ... tracks) {
            this.tracks(Stream.of(tracks).map(c -> (ServerlessTrack)((ServerlessTrack.Builder)ServerlessTrack.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTracksResponse build() {
            return new ListTracksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTracksResponse> {
        public Builder nextToken(String var1);

        public Builder tracks(Collection<ServerlessTrack> var1);

        public Builder tracks(ServerlessTrack ... var1);

        public Builder tracks(Consumer<ServerlessTrack.Builder> ... var1);
    }
}

