/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.redshiftserverless.DefaultRedshiftServerlessBaseClientBuilder;
import software.amazon.awssdk.services.redshiftserverless.DefaultRedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClientBuilder;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessServiceClientConfiguration;
import software.amazon.awssdk.services.redshiftserverless.endpoints.RedshiftServerlessEndpointProvider;

@SdkInternalApi
final class DefaultRedshiftServerlessClientBuilder
extends DefaultRedshiftServerlessBaseClientBuilder<RedshiftServerlessClientBuilder, RedshiftServerlessClient>
implements RedshiftServerlessClientBuilder {
    DefaultRedshiftServerlessClientBuilder() {
    }

    @Override
    public DefaultRedshiftServerlessClientBuilder endpointProvider(RedshiftServerlessEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RedshiftServerlessClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRedshiftServerlessClientBuilder.validateClientOptions(clientConfiguration);
        RedshiftServerlessServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRedshiftServerlessClient client = new DefaultRedshiftServerlessClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RedshiftServerlessServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RedshiftServerlessServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

