/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The automatically created recovery point of a namespace. Recovery points are created every 30 minutes and kept for 24
 * hours.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryPoint implements SdkPojo, Serializable, ToCopyableBuilder<RecoveryPoint.Builder, RecoveryPoint> {
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceArn").getter(getter(RecoveryPoint::namespaceArn)).setter(setter(Builder::namespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(RecoveryPoint::namespaceName)).setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<Instant> RECOVERY_POINT_CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("recoveryPointCreateTime")
            .getter(getter(RecoveryPoint::recoveryPointCreateTime))
            .setter(setter(Builder::recoveryPointCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPointCreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> RECOVERY_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryPointId").getter(getter(RecoveryPoint::recoveryPointId))
            .setter(setter(Builder::recoveryPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPointId").build()).build();

    private static final SdkField<Double> TOTAL_SIZE_IN_MEGA_BYTES_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("totalSizeInMegaBytes").getter(getter(RecoveryPoint::totalSizeInMegaBytes))
            .setter(setter(Builder::totalSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSizeInMegaBytes").build())
            .build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(RecoveryPoint::workgroupName)).setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_ARN_FIELD,
            NAMESPACE_NAME_FIELD, RECOVERY_POINT_CREATE_TIME_FIELD, RECOVERY_POINT_ID_FIELD, TOTAL_SIZE_IN_MEGA_BYTES_FIELD,
            WORKGROUP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namespaceArn;

    private final String namespaceName;

    private final Instant recoveryPointCreateTime;

    private final String recoveryPointId;

    private final Double totalSizeInMegaBytes;

    private final String workgroupName;

    private RecoveryPoint(BuilderImpl builder) {
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.recoveryPointCreateTime = builder.recoveryPointCreateTime;
        this.recoveryPointId = builder.recoveryPointId;
        this.totalSizeInMegaBytes = builder.totalSizeInMegaBytes;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the namespace the recovery point is associated with.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the namespace the recovery point is associated with.
     */
    public final String namespaceArn() {
        return namespaceArn;
    }

    /**
     * <p>
     * The name of the namespace the recovery point is associated with.
     * </p>
     * 
     * @return The name of the namespace the recovery point is associated with.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The time the recovery point is created.
     * </p>
     * 
     * @return The time the recovery point is created.
     */
    public final Instant recoveryPointCreateTime() {
        return recoveryPointCreateTime;
    }

    /**
     * <p>
     * The unique identifier of the recovery point.
     * </p>
     * 
     * @return The unique identifier of the recovery point.
     */
    public final String recoveryPointId() {
        return recoveryPointId;
    }

    /**
     * <p>
     * The total size of the data in the recovery point in megabytes.
     * </p>
     * 
     * @return The total size of the data in the recovery point in megabytes.
     */
    public final Double totalSizeInMegaBytes() {
        return totalSizeInMegaBytes;
    }

    /**
     * <p>
     * The name of the workgroup the recovery point is associated with.
     * </p>
     * 
     * @return The name of the workgroup the recovery point is associated with.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointId());
        hashCode = 31 * hashCode + Objects.hashCode(totalSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPoint)) {
            return false;
        }
        RecoveryPoint other = (RecoveryPoint) obj;
        return Objects.equals(namespaceArn(), other.namespaceArn()) && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(recoveryPointCreateTime(), other.recoveryPointCreateTime())
                && Objects.equals(recoveryPointId(), other.recoveryPointId())
                && Objects.equals(totalSizeInMegaBytes(), other.totalSizeInMegaBytes())
                && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryPoint").add("NamespaceArn", namespaceArn()).add("NamespaceName", namespaceName())
                .add("RecoveryPointCreateTime", recoveryPointCreateTime()).add("RecoveryPointId", recoveryPointId())
                .add("TotalSizeInMegaBytes", totalSizeInMegaBytes()).add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespaceArn":
            return Optional.ofNullable(clazz.cast(namespaceArn()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "recoveryPointCreateTime":
            return Optional.ofNullable(clazz.cast(recoveryPointCreateTime()));
        case "recoveryPointId":
            return Optional.ofNullable(clazz.cast(recoveryPointId()));
        case "totalSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalSizeInMegaBytes()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPoint, T> g) {
        return obj -> g.apply((RecoveryPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryPoint> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the namespace the recovery point is associated with.
         * </p>
         * 
         * @param namespaceArn
         *        The Amazon Resource Name (ARN) of the namespace the recovery point is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceArn(String namespaceArn);

        /**
         * <p>
         * The name of the namespace the recovery point is associated with.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace the recovery point is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The time the recovery point is created.
         * </p>
         * 
         * @param recoveryPointCreateTime
         *        The time the recovery point is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointCreateTime(Instant recoveryPointCreateTime);

        /**
         * <p>
         * The unique identifier of the recovery point.
         * </p>
         * 
         * @param recoveryPointId
         *        The unique identifier of the recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointId(String recoveryPointId);

        /**
         * <p>
         * The total size of the data in the recovery point in megabytes.
         * </p>
         * 
         * @param totalSizeInMegaBytes
         *        The total size of the data in the recovery point in megabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSizeInMegaBytes(Double totalSizeInMegaBytes);

        /**
         * <p>
         * The name of the workgroup the recovery point is associated with.
         * </p>
         * 
         * @param workgroupName
         *        The name of the workgroup the recovery point is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);
    }

    static final class BuilderImpl implements Builder {
        private String namespaceArn;

        private String namespaceName;

        private Instant recoveryPointCreateTime;

        private String recoveryPointId;

        private Double totalSizeInMegaBytes;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPoint model) {
            namespaceArn(model.namespaceArn);
            namespaceName(model.namespaceName);
            recoveryPointCreateTime(model.recoveryPointCreateTime);
            recoveryPointId(model.recoveryPointId);
            totalSizeInMegaBytes(model.totalSizeInMegaBytes);
            workgroupName(model.workgroupName);
        }

        public final String getNamespaceArn() {
            return namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Instant getRecoveryPointCreateTime() {
            return recoveryPointCreateTime;
        }

        public final void setRecoveryPointCreateTime(Instant recoveryPointCreateTime) {
            this.recoveryPointCreateTime = recoveryPointCreateTime;
        }

        @Override
        public final Builder recoveryPointCreateTime(Instant recoveryPointCreateTime) {
            this.recoveryPointCreateTime = recoveryPointCreateTime;
            return this;
        }

        public final String getRecoveryPointId() {
            return recoveryPointId;
        }

        public final void setRecoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
        }

        @Override
        public final Builder recoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
            return this;
        }

        public final Double getTotalSizeInMegaBytes() {
            return totalSizeInMegaBytes;
        }

        public final void setTotalSizeInMegaBytes(Double totalSizeInMegaBytes) {
            this.totalSizeInMegaBytes = totalSizeInMegaBytes;
        }

        @Override
        public final Builder totalSizeInMegaBytes(Double totalSizeInMegaBytes) {
            this.totalSizeInMegaBytes = totalSizeInMegaBytes;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public RecoveryPoint build() {
            return new RecoveryPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
