/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher;

/**
 * Service client for accessing Redshift Serverless asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * This is an interface reference for Amazon Redshift Serverless. It contains documentation for one of the programming
 * or command line interfaces you can use to manage Amazon Redshift Serverless.
 * </p>
 * <p>
 * Amazon Redshift Serverless automatically provisions data warehouse capacity and intelligently scales the underlying
 * resources based on workload demands. Amazon Redshift Serverless adjusts capacity in seconds to deliver consistently
 * high performance and simplified operations for even the most demanding and volatile workloads. Amazon Redshift
 * Serverless lets you focus on using your data to acquire new insights for your business and customers.
 * </p>
 * <p>
 * To learn more about Amazon Redshift Serverless, see <a
 * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-whatis.html">What is Amazon Redshift
 * Serverless</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RedshiftServerlessAsyncClient extends AwsClient {
    String SERVICE_NAME = "redshift-serverless";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "redshift-serverless";

    /**
     * <p>
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html">Working with snapshots
     * and recovery points</a>.
     * </p>
     *
     * @param convertRecoveryPointToSnapshotRequest
     * @return A Java Future containing the result of the ConvertRecoveryPointToSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ConvertRecoveryPointToSnapshot
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConvertRecoveryPointToSnapshotResponse> convertRecoveryPointToSnapshot(
            ConvertRecoveryPointToSnapshotRequest convertRecoveryPointToSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html">Working with snapshots
     * and recovery points</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConvertRecoveryPointToSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link ConvertRecoveryPointToSnapshotRequest#builder()}
     * </p>
     *
     * @param convertRecoveryPointToSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link ConvertRecoveryPointToSnapshotRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ConvertRecoveryPointToSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ConvertRecoveryPointToSnapshot
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConvertRecoveryPointToSnapshotResponse> convertRecoveryPointToSnapshot(
            Consumer<ConvertRecoveryPointToSnapshotRequest.Builder> convertRecoveryPointToSnapshotRequest) {
        return convertRecoveryPointToSnapshot(ConvertRecoveryPointToSnapshotRequest.builder()
                .applyMutation(convertRecoveryPointToSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param createEndpointAccessRequest
     * @return A Java Future containing the result of the CreateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointAccessResponse> createEndpointAccess(
            CreateEndpointAccessRequest createEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointAccessRequest#builder()}
     * </p>
     *
     * @param createEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointAccessResponse> createEndpointAccess(
            Consumer<CreateEndpointAccessRequest.Builder> createEndpointAccessRequest) {
        return createEndpointAccess(CreateEndpointAccessRequest.builder().applyMutation(createEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Creates a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param createNamespaceRequest
     * @return A Java Future containing the result of the CreateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest createNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a namespace in Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNamespaceRequest#builder()}
     * </p>
     *
     * @param createNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link CreateNamespaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNamespaceResponse> createNamespace(
            Consumer<CreateNamespaceRequest.Builder> createNamespaceRequest) {
        return createNamespace(CreateNamespaceRequest.builder().applyMutation(createNamespaceRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html"> Working with
     * snapshots and recovery points</a>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html"> Working with
     * snapshots and recovery points</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotResponse> createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest) {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     *
     * @param createUsageLimitRequest
     * @return A Java Future containing the result of the CreateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUsageLimitResponse> createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUsageLimitRequest#builder()}
     * </p>
     *
     * @param createUsageLimitRequest
     *        A {@link Consumer} that will call methods on {@link CreateUsageLimitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUsageLimitResponse> createUsageLimit(
            Consumer<CreateUsageLimitRequest.Builder> createUsageLimitRequest) {
        return createUsageLimit(CreateUsageLimitRequest.builder().applyMutation(createUsageLimitRequest).build());
    }

    /**
     * <p>
     * Creates an workgroup in Amazon Redshift Serverless.
     * </p>
     *
     * @param createWorkgroupRequest
     * @return A Java Future containing the result of the CreateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkgroupResponse> createWorkgroup(CreateWorkgroupRequest createWorkgroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an workgroup in Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkgroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkgroupRequest#builder()}
     * </p>
     *
     * @param createWorkgroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkgroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.CreateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkgroupResponse> createWorkgroup(
            Consumer<CreateWorkgroupRequest.Builder> createWorkgroupRequest) {
        return createWorkgroup(CreateWorkgroupRequest.builder().applyMutation(createWorkgroupRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     *
     * @param deleteEndpointAccessRequest
     * @return A Java Future containing the result of the DeleteEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointAccessResponse> deleteEndpointAccess(
            DeleteEndpointAccessRequest deleteEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointAccessRequest#builder()}
     * </p>
     *
     * @param deleteEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointAccessResponse> deleteEndpointAccess(
            Consumer<DeleteEndpointAccessRequest.Builder> deleteEndpointAccessRequest) {
        return deleteEndpointAccess(DeleteEndpointAccessRequest.builder().applyMutation(deleteEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final
     * snapshot that has all of the data within the namespace.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final
     * snapshot that has all of the data within the namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNamespaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(
            Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest) {
        return deleteNamespace(DeleteNamespaceRequest.builder().applyMutation(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a snapshot from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a snapshot from Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(Consumer<DeleteSnapshotRequest.Builder> deleteSnapshotRequest) {
        return deleteSnapshot(DeleteSnapshotRequest.builder().applyMutation(deleteSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes a usage limit from Amazon Redshift Serverless.
     * </p>
     *
     * @param deleteUsageLimitRequest
     * @return A Java Future containing the result of the DeleteUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a usage limit from Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUsageLimitRequest#builder()}
     * </p>
     *
     * @param deleteUsageLimitRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUsageLimitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(
            Consumer<DeleteUsageLimitRequest.Builder> deleteUsageLimitRequest) {
        return deleteUsageLimit(DeleteUsageLimitRequest.builder().applyMutation(deleteUsageLimitRequest).build());
    }

    /**
     * <p>
     * Deletes a workgroup.
     * </p>
     *
     * @param deleteWorkgroupRequest
     * @return A Java Future containing the result of the DeleteWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkgroupResponse> deleteWorkgroup(DeleteWorkgroupRequest deleteWorkgroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkgroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkgroupRequest#builder()}
     * </p>
     *
     * @param deleteWorkgroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkgroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.DeleteWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkgroupResponse> deleteWorkgroup(
            Consumer<DeleteWorkgroupRequest.Builder> deleteWorkgroupRequest) {
        return deleteWorkgroup(DeleteWorkgroupRequest.builder().applyMutation(deleteWorkgroupRequest).build());
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift
     * Serverless.
     * </p>
     * <p>
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900
     * seconds (15 minutes) and 3600 seconds (60 minutes).
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.&lt;/p&gt; &lt;p&gt;If the &lt;code&gt;DbName&lt;/code&gt; parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.&lt;/p&gt; </code>
     * </pre>
     *
     * @param getCredentialsRequest
     * @return A Java Future containing the result of the GetCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCredentialsResponse> getCredentials(GetCredentialsRequest getCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift
     * Serverless.
     * </p>
     * <p>
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900
     * seconds (15 minutes) and 3600 seconds (60 minutes).
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.&lt;/p&gt; &lt;p&gt;If the &lt;code&gt;DbName&lt;/code&gt; parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.&lt;/p&gt; </code>
     * </pre>
     * 
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCredentialsRequest.Builder} avoiding the need to
     * create one manually via {@link GetCredentialsRequest#builder()}
     * </p>
     *
     * @param getCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link GetCredentialsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCredentialsResponse> getCredentials(Consumer<GetCredentialsRequest.Builder> getCredentialsRequest) {
        return getCredentials(GetCredentialsRequest.builder().applyMutation(getCredentialsRequest).build());
    }

    /**
     * <p>
     * Returns information, such as the name, about a VPC endpoint.
     * </p>
     *
     * @param getEndpointAccessRequest
     * @return A Java Future containing the result of the GetEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEndpointAccessResponse> getEndpointAccess(GetEndpointAccessRequest getEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information, such as the name, about a VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEndpointAccessRequest.Builder} avoiding the need
     * to create one manually via {@link GetEndpointAccessRequest#builder()}
     * </p>
     *
     * @param getEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link GetEndpointAccessRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEndpointAccessResponse> getEndpointAccess(
            Consumer<GetEndpointAccessRequest.Builder> getEndpointAccessRequest) {
        return getEndpointAccess(GetEndpointAccessRequest.builder().applyMutation(getEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Returns information about a namespace in Amazon Redshift Serverless.
     * </p>
     *
     * @param getNamespaceRequest
     * @return A Java Future containing the result of the GetNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNamespaceResponse> getNamespace(GetNamespaceRequest getNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a namespace in Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNamespaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetNamespaceRequest#builder()}
     * </p>
     *
     * @param getNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link GetNamespaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNamespaceResponse> getNamespace(Consumer<GetNamespaceRequest.Builder> getNamespaceRequest) {
        return getNamespace(GetNamespaceRequest.builder().applyMutation(getNamespaceRequest).build());
    }

    /**
     * <p>
     * Returns information about a recovery point.
     * </p>
     *
     * @param getRecoveryPointRequest
     * @return A Java Future containing the result of the GetRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryPointResponse> getRecoveryPoint(GetRecoveryPointRequest getRecoveryPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecoveryPointRequest.Builder} avoiding the need
     * to create one manually via {@link GetRecoveryPointRequest#builder()}
     * </p>
     *
     * @param getRecoveryPointRequest
     *        A {@link Consumer} that will call methods on {@link GetRecoveryPointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryPointResponse> getRecoveryPoint(
            Consumer<GetRecoveryPointRequest.Builder> getRecoveryPointRequest) {
        return getRecoveryPoint(GetRecoveryPointRequest.builder().applyMutation(getRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Returns a resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific snapshot.
     * </p>
     *
     * @param getSnapshotRequest
     * @return A Java Future containing the result of the GetSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSnapshotResponse> getSnapshot(GetSnapshotRequest getSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link GetSnapshotRequest#builder()}
     * </p>
     *
     * @param getSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link GetSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSnapshotResponse> getSnapshot(Consumer<GetSnapshotRequest.Builder> getSnapshotRequest) {
        return getSnapshot(GetSnapshotRequest.builder().applyMutation(getSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns information about a <code>TableRestoreStatus</code> object.
     * </p>
     *
     * @param getTableRestoreStatusRequest
     * @return A Java Future containing the result of the GetTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableRestoreStatusResponse> getTableRestoreStatus(
            GetTableRestoreStatusRequest getTableRestoreStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a <code>TableRestoreStatus</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableRestoreStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param getTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetTableRestoreStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTableRestoreStatusResponse> getTableRestoreStatus(
            Consumer<GetTableRestoreStatusRequest.Builder> getTableRestoreStatusRequest) {
        return getTableRestoreStatus(GetTableRestoreStatusRequest.builder().applyMutation(getTableRestoreStatusRequest).build());
    }

    /**
     * <p>
     * Returns information about a usage limit.
     * </p>
     *
     * @param getUsageLimitRequest
     * @return A Java Future containing the result of the GetUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUsageLimitResponse> getUsageLimit(GetUsageLimitRequest getUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a usage limit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageLimitRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsageLimitRequest#builder()}
     * </p>
     *
     * @param getUsageLimitRequest
     *        A {@link Consumer} that will call methods on {@link GetUsageLimitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUsageLimitResponse> getUsageLimit(Consumer<GetUsageLimitRequest.Builder> getUsageLimitRequest) {
        return getUsageLimit(GetUsageLimitRequest.builder().applyMutation(getUsageLimitRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific workgroup.
     * </p>
     *
     * @param getWorkgroupRequest
     * @return A Java Future containing the result of the GetWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkgroupResponse> getWorkgroup(GetWorkgroupRequest getWorkgroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkgroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkgroupRequest#builder()}
     * </p>
     *
     * @param getWorkgroupRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkgroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.GetWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkgroupResponse> getWorkgroup(Consumer<GetWorkgroupRequest.Builder> getWorkgroupRequest) {
        return getWorkgroup(GetWorkgroupRequest.builder().applyMutation(getWorkgroupRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     *
     * @param listEndpointAccessRequest
     * @return A Java Future containing the result of the ListEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointAccessResponse> listEndpointAccess(ListEndpointAccessRequest listEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointAccessRequest#builder()}
     * </p>
     *
     * @param listEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointAccessResponse> listEndpointAccess(
            Consumer<ListEndpointAccessRequest.Builder> listEndpointAccessRequest) {
        return listEndpointAccess(ListEndpointAccessRequest.builder().applyMutation(listEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher publisher = client.listEndpointAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher publisher = client.listEndpointAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEndpointAccessRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointAccessPublisher listEndpointAccessPaginator(ListEndpointAccessRequest listEndpointAccessRequest) {
        return new ListEndpointAccessPublisher(this, listEndpointAccessRequest);
    }

    /**
     * <p>
     * Returns an array of <code>EndpointAccess</code> objects and relevant information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher publisher = client.listEndpointAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessPublisher publisher = client.listEndpointAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointAccess(software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointAccessRequest#builder()}
     * </p>
     *
     * @param listEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointAccessRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointAccessPublisher listEndpointAccessPaginator(
            Consumer<ListEndpointAccessRequest.Builder> listEndpointAccessRequest) {
        return listEndpointAccessPaginator(ListEndpointAccessRequest.builder().applyMutation(listEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     *
     * @param listNamespacesRequest
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNamespacesResponse> listNamespaces(ListNamespacesRequest listNamespacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on {@link ListNamespacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNamespacesResponse> listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) {
        return listNamespaces(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNamespacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesPublisher listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest) {
        return new ListNamespacesPublisher(this, listNamespacesRequest);
    }

    /**
     * <p>
     * Returns information about a list of specified namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on {@link ListNamespacesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesPublisher listNamespacesPaginator(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) {
        return listNamespacesPaginator(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     *
     * @param listRecoveryPointsRequest
     * @return A Java Future containing the result of the ListRecoveryPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsResponse> listRecoveryPoints(ListRecoveryPointsRequest listRecoveryPointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecoveryPointsRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsRequest
     *        A {@link Consumer} that will call methods on {@link ListRecoveryPointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRecoveryPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsResponse> listRecoveryPoints(
            Consumer<ListRecoveryPointsRequest.Builder> listRecoveryPointsRequest) {
        return listRecoveryPoints(ListRecoveryPointsRequest.builder().applyMutation(listRecoveryPointsRequest).build());
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher publisher = client.listRecoveryPointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher publisher = client.listRecoveryPointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsPublisher listRecoveryPointsPaginator(ListRecoveryPointsRequest listRecoveryPointsRequest) {
        return new ListRecoveryPointsPublisher(this, listRecoveryPointsRequest);
    }

    /**
     * <p>
     * Returns an array of recovery points.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher publisher = client.listRecoveryPointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsPublisher publisher = client.listRecoveryPointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPoints(software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecoveryPointsRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsRequest
     *        A {@link Consumer} that will call methods on {@link ListRecoveryPointsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListRecoveryPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsPublisher listRecoveryPointsPaginator(
            Consumer<ListRecoveryPointsRequest.Builder> listRecoveryPointsRequest) {
        return listRecoveryPointsPaginator(ListRecoveryPointsRequest.builder().applyMutation(listRecoveryPointsRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     *
     * @param listSnapshotsRequest
     * @return A Java Future containing the result of the ListSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSnapshotsResponse> listSnapshots(ListSnapshotsRequest listSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSnapshotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSnapshotsResponse> listSnapshots(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest) {
        return listSnapshots(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotsPublisher listSnapshotsPaginator(ListSnapshotsRequest listSnapshotsRequest) {
        return new ListSnapshotsPublisher(this, listSnapshotsRequest);
    }

    /**
     * <p>
     * Returns a list of snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsPublisher publisher = client.listSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSnapshotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnapshotsPublisher listSnapshotsPaginator(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest) {
        return listSnapshotsPaginator(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     *
     * @param listTableRestoreStatusRequest
     * @return A Java Future containing the result of the ListTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTableRestoreStatusResponse> listTableRestoreStatus(
            ListTableRestoreStatusRequest listTableRestoreStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRestoreStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param listTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListTableRestoreStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTableRestoreStatusResponse> listTableRestoreStatus(
            Consumer<ListTableRestoreStatusRequest.Builder> listTableRestoreStatusRequest) {
        return listTableRestoreStatus(ListTableRestoreStatusRequest.builder().applyMutation(listTableRestoreStatusRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher publisher = client.listTableRestoreStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher publisher = client.listTableRestoreStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTableRestoreStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableRestoreStatusPublisher listTableRestoreStatusPaginator(
            ListTableRestoreStatusRequest listTableRestoreStatusRequest) {
        return new ListTableRestoreStatusPublisher(this, listTableRestoreStatusRequest);
    }

    /**
     * <p>
     * Returns information about an array of <code>TableRestoreStatus</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher publisher = client.listTableRestoreStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusPublisher publisher = client.listTableRestoreStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableRestoreStatus(software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableRestoreStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param listTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListTableRestoreStatusRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableRestoreStatusPublisher listTableRestoreStatusPaginator(
            Consumer<ListTableRestoreStatusRequest.Builder> listTableRestoreStatusRequest) {
        return listTableRestoreStatusPaginator(ListTableRestoreStatusRequest.builder()
                .applyMutation(listTableRestoreStatusRequest).build());
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     *
     * @param listUsageLimitsRequest
     * @return A Java Future containing the result of the ListUsageLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsageLimitsResponse> listUsageLimits(ListUsageLimitsRequest listUsageLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageLimitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageLimitsRequest#builder()}
     * </p>
     *
     * @param listUsageLimitsRequest
     *        A {@link Consumer} that will call methods on {@link ListUsageLimitsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUsageLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUsageLimitsResponse> listUsageLimits(
            Consumer<ListUsageLimitsRequest.Builder> listUsageLimitsRequest) {
        return listUsageLimits(ListUsageLimitsRequest.builder().applyMutation(listUsageLimitsRequest).build());
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher publisher = client.listUsageLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher publisher = client.listUsageLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUsageLimitsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageLimitsPublisher listUsageLimitsPaginator(ListUsageLimitsRequest listUsageLimitsRequest) {
        return new ListUsageLimitsPublisher(this, listUsageLimitsRequest);
    }

    /**
     * <p>
     * Lists all usage limits within Amazon Redshift Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher publisher = client.listUsageLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsPublisher publisher = client.listUsageLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsageLimits(software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsageLimitsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsageLimitsRequest#builder()}
     * </p>
     *
     * @param listUsageLimitsRequest
     *        A {@link Consumer} that will call methods on {@link ListUsageLimitsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InvalidPaginationException The provided pagination token is invalid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUsageLimitsPublisher listUsageLimitsPaginator(Consumer<ListUsageLimitsRequest.Builder> listUsageLimitsRequest) {
        return listUsageLimitsPaginator(ListUsageLimitsRequest.builder().applyMutation(listUsageLimitsRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     *
     * @param listWorkgroupsRequest
     * @return A Java Future containing the result of the ListWorkgroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkgroupsResponse> listWorkgroups(ListWorkgroupsRequest listWorkgroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkgroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkgroupsRequest#builder()}
     * </p>
     *
     * @param listWorkgroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkgroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWorkgroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkgroupsResponse> listWorkgroups(Consumer<ListWorkgroupsRequest.Builder> listWorkgroupsRequest) {
        return listWorkgroups(ListWorkgroupsRequest.builder().applyMutation(listWorkgroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher publisher = client.listWorkgroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher publisher = client.listWorkgroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkgroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkgroupsPublisher listWorkgroupsPaginator(ListWorkgroupsRequest listWorkgroupsRequest) {
        return new ListWorkgroupsPublisher(this, listWorkgroupsRequest);
    }

    /**
     * <p>
     * Returns information about a list of specified workgroups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher publisher = client.listWorkgroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsPublisher publisher = client.listWorkgroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkgroups(software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkgroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkgroupsRequest#builder()}
     * </p>
     *
     * @param listWorkgroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkgroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.ListWorkgroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkgroupsPublisher listWorkgroupsPaginator(Consumer<ListWorkgroupsRequest.Builder> listWorkgroupsRequest) {
        return listWorkgroupsPaginator(ListWorkgroupsRequest.builder().applyMutation(listWorkgroupsRequest).build());
    }

    /**
     * <p>
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web
     * Services accounts.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web
     * Services accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Restore the data from a recovery point.
     * </p>
     *
     * @param restoreFromRecoveryPointRequest
     * @return A Java Future containing the result of the RestoreFromRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreFromRecoveryPointResponse> restoreFromRecoveryPoint(
            RestoreFromRecoveryPointRequest restoreFromRecoveryPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restore the data from a recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreFromRecoveryPointRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreFromRecoveryPointRequest#builder()}
     * </p>
     *
     * @param restoreFromRecoveryPointRequest
     *        A {@link Consumer} that will call methods on {@link RestoreFromRecoveryPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestoreFromRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreFromRecoveryPointResponse> restoreFromRecoveryPoint(
            Consumer<RestoreFromRecoveryPointRequest.Builder> restoreFromRecoveryPointRequest) {
        return restoreFromRecoveryPoint(RestoreFromRecoveryPointRequest.builder().applyMutation(restoreFromRecoveryPointRequest)
                .build());
    }

    /**
     * <p>
     * Restores a namespace from a snapshot.
     * </p>
     *
     * @param restoreFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreFromSnapshotResponse> restoreFromSnapshot(
            RestoreFromSnapshotRequest restoreFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a namespace from a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreFromSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link RestoreFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreFromSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link RestoreFromSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestoreFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ServiceQuotaExceededException The service limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreFromSnapshotResponse> restoreFromSnapshot(
            Consumer<RestoreFromSnapshotRequest.Builder> restoreFromSnapshotRequest) {
        return restoreFromSnapshot(RestoreFromSnapshotRequest.builder().applyMutation(restoreFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to
     * restore tables with <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved
     * sort keys</a>.
     * </p>
     *
     * @param restoreTableFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreTableFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreTableFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableFromSnapshotResponse> restoreTableFromSnapshot(
            RestoreTableFromSnapshotRequest restoreTableFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to
     * restore tables with <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved
     * sort keys</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreTableFromSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreTableFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreTableFromSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link RestoreTableFromSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestoreTableFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.RestoreTableFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreTableFromSnapshotResponse> restoreTableFromSnapshot(
            Consumer<RestoreTableFromSnapshotRequest.Builder> restoreTableFromSnapshotRequest) {
        return restoreTableFromSnapshot(RestoreTableFromSnapshotRequest.builder().applyMutation(restoreTableFromSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Assigns one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>TooManyTagsException The request exceeded the number of tags allowed for a resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or set of tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or set of tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless managed endpoint.
     * </p>
     *
     * @param updateEndpointAccessRequest
     * @return A Java Future containing the result of the UpdateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointAccessResponse> updateEndpointAccess(
            UpdateEndpointAccessRequest updateEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Redshift Serverless managed endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEndpointAccessRequest#builder()}
     * </p>
     *
     * @param updateEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointAccessResponse> updateEndpointAccess(
            Consumer<UpdateEndpointAccessRequest.Builder> updateEndpointAccessRequest) {
        return updateEndpointAccess(UpdateEndpointAccessRequest.builder().applyMutation(updateEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one
     * request. For example, you must specify both <code>adminUsername</code> and <code>adminUserPassword</code> to
     * update either field, but you can't update both <code>kmsKeyId</code> and <code>logExports</code> in a single
     * request.
     * </p>
     *
     * @param updateNamespaceRequest
     * @return A Java Future containing the result of the UpdateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNamespaceResponse> updateNamespace(UpdateNamespaceRequest updateNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a namespace with the specified settings. Unless required, you can't update multiple parameters in one
     * request. For example, you must specify both <code>adminUsername</code> and <code>adminUserPassword</code> to
     * update either field, but you can't update both <code>kmsKeyId</code> and <code>logExports</code> in a single
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateNamespaceRequest#builder()}
     * </p>
     *
     * @param updateNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNamespaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNamespaceResponse> updateNamespace(
            Consumer<UpdateNamespaceRequest.Builder> updateNamespaceRequest) {
        return updateNamespace(UpdateNamespaceRequest.builder().applyMutation(updateNamespaceRequest).build());
    }

    /**
     * <p>
     * Updates a snapshot.
     * </p>
     *
     * @param updateSnapshotRequest
     * @return A Java Future containing the result of the UpdateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSnapshotResponse> updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSnapshotRequest#builder()}
     * </p>
     *
     * @param updateSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSnapshotResponse> updateSnapshot(Consumer<UpdateSnapshotRequest.Builder> updateSnapshotRequest) {
        return updateSnapshot(UpdateSnapshotRequest.builder().applyMutation(updateSnapshotRequest).build());
    }

    /**
     * <p>
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     * </p>
     *
     * @param updateUsageLimitRequest
     * @return A Java Future containing the result of the UpdateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUsageLimitResponse> updateUsageLimit(UpdateUsageLimitRequest updateUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateUsageLimitRequest#builder()}
     * </p>
     *
     * @param updateUsageLimitRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUsageLimitRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUsageLimitResponse> updateUsageLimit(
            Consumer<UpdateUsageLimitRequest.Builder> updateUsageLimitRequest) {
        return updateUsageLimit(UpdateUsageLimitRequest.builder().applyMutation(updateUsageLimitRequest).build());
    }

    /**
     * <p>
     * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one
     * request. For example, you can update <code>baseCapacity</code> or <code>port</code> in a single request, but you
     * can't update both in the same request.
     * </p>
     *
     * @param updateWorkgroupRequest
     * @return A Java Future containing the result of the UpdateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkgroupResponse> updateWorkgroup(UpdateWorkgroupRequest updateWorkgroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a workgroup with the specified configuration settings. You can't update multiple parameters in one
     * request. For example, you can update <code>baseCapacity</code> or <code>port</code> in a single request, but you
     * can't update both in the same request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkgroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWorkgroupRequest#builder()}
     * </p>
     *
     * @param updateWorkgroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkgroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWorkgroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>InsufficientCapacityException There is an insufficient capacity to perform the action.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ConflictException The submitted action has conflicts.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by an AWS service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftServerlessException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample RedshiftServerlessAsyncClient.UpdateWorkgroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkgroupResponse> updateWorkgroup(
            Consumer<UpdateWorkgroupRequest.Builder> updateWorkgroupRequest) {
        return updateWorkgroup(UpdateWorkgroupRequest.builder().applyMutation(updateWorkgroupRequest).build());
    }

    @Override
    default RedshiftServerlessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link RedshiftServerlessAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RedshiftServerlessAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RedshiftServerlessAsyncClient}.
     */
    static RedshiftServerlessAsyncClientBuilder builder() {
        return new DefaultRedshiftServerlessAsyncClientBuilder();
    }
}
