/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.IamRoleArnListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.LogExport;
import software.amazon.awssdk.services.redshiftserverless.model.LogExportListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.Tag;
import software.amazon.awssdk.services.redshiftserverless.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNamespaceRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, CreateNamespaceRequest> {
    private static final SdkField<String> ADMIN_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminUserPassword").getter(CreateNamespaceRequest.getter(CreateNamespaceRequest::adminUserPassword)).setter(CreateNamespaceRequest.setter(Builder::adminUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserPassword").build()}).build();
    private static final SdkField<String> ADMIN_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminUsername").getter(CreateNamespaceRequest.getter(CreateNamespaceRequest::adminUsername)).setter(CreateNamespaceRequest.setter(Builder::adminUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUsername").build()}).build();
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbName").getter(CreateNamespaceRequest.getter(CreateNamespaceRequest::dbName)).setter(CreateNamespaceRequest.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbName").build()}).build();
    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultIamRoleArn").getter(CreateNamespaceRequest.getter(CreateNamespaceRequest::defaultIamRoleArn)).setter(CreateNamespaceRequest.setter(Builder::defaultIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultIamRoleArn").build()}).build();
    private static final SdkField<List<String>> IAM_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("iamRoles").getter(CreateNamespaceRequest.getter(CreateNamespaceRequest::iamRoles)).setter(CreateNamespaceRequest.setter(Builder::iamRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(CreateNamespaceRequest.getter(CreateNamespaceRequest::kmsKeyId)).setter(CreateNamespaceRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<List<String>> LOG_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logExports").getter(CreateNamespaceRequest.getter(CreateNamespaceRequest::logExportsAsStrings)).setter(CreateNamespaceRequest.setter(Builder::logExportsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(CreateNamespaceRequest.getter(CreateNamespaceRequest::namespaceName)).setter(CreateNamespaceRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateNamespaceRequest.getter(CreateNamespaceRequest::tags)).setter(CreateNamespaceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USER_PASSWORD_FIELD, ADMIN_USERNAME_FIELD, DB_NAME_FIELD, DEFAULT_IAM_ROLE_ARN_FIELD, IAM_ROLES_FIELD, KMS_KEY_ID_FIELD, LOG_EXPORTS_FIELD, NAMESPACE_NAME_FIELD, TAGS_FIELD));
    private final String adminUserPassword;
    private final String adminUsername;
    private final String dbName;
    private final String defaultIamRoleArn;
    private final List<String> iamRoles;
    private final String kmsKeyId;
    private final List<String> logExports;
    private final String namespaceName;
    private final List<Tag> tags;

    private CreateNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.adminUserPassword = builder.adminUserPassword;
        this.adminUsername = builder.adminUsername;
        this.dbName = builder.dbName;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
        this.iamRoles = builder.iamRoles;
        this.kmsKeyId = builder.kmsKeyId;
        this.logExports = builder.logExports;
        this.namespaceName = builder.namespaceName;
        this.tags = builder.tags;
    }

    public final String adminUserPassword() {
        return this.adminUserPassword;
    }

    public final String adminUsername() {
        return this.adminUsername;
    }

    public final String dbName() {
        return this.dbName;
    }

    public final String defaultIamRoleArn() {
        return this.defaultIamRoleArn;
    }

    public final boolean hasIamRoles() {
        return this.iamRoles != null && !(this.iamRoles instanceof SdkAutoConstructList);
    }

    public final List<String> iamRoles() {
        return this.iamRoles;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final List<LogExport> logExports() {
        return LogExportListCopier.copyStringToEnum(this.logExports);
    }

    public final boolean hasLogExports() {
        return this.logExports != null && !(this.logExports instanceof SdkAutoConstructList);
    }

    public final List<String> logExportsAsStrings() {
        return this.logExports;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIamRoles() ? this.iamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogExports() ? this.logExportsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNamespaceRequest)) {
            return false;
        }
        CreateNamespaceRequest other = (CreateNamespaceRequest)((Object)obj);
        return Objects.equals(this.adminUserPassword(), other.adminUserPassword()) && Objects.equals(this.adminUsername(), other.adminUsername()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.defaultIamRoleArn(), other.defaultIamRoleArn()) && this.hasIamRoles() == other.hasIamRoles() && Objects.equals(this.iamRoles(), other.iamRoles()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasLogExports() == other.hasLogExports() && Objects.equals(this.logExportsAsStrings(), other.logExportsAsStrings()) && Objects.equals(this.namespaceName(), other.namespaceName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNamespaceRequest").add("AdminUserPassword", (Object)(this.adminUserPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("AdminUsername", (Object)(this.adminUsername() == null ? null : "*** Sensitive Data Redacted ***")).add("DbName", (Object)this.dbName()).add("DefaultIamRoleArn", (Object)this.defaultIamRoleArn()).add("IamRoles", this.hasIamRoles() ? this.iamRoles() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("LogExports", this.hasLogExports() ? this.logExportsAsStrings() : null).add("NamespaceName", (Object)this.namespaceName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminUserPassword": {
                return Optional.ofNullable(clazz.cast(this.adminUserPassword()));
            }
            case "adminUsername": {
                return Optional.ofNullable(clazz.cast(this.adminUsername()));
            }
            case "dbName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "defaultIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.defaultIamRoleArn()));
            }
            case "iamRoles": {
                return Optional.ofNullable(clazz.cast(this.iamRoles()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "logExports": {
                return Optional.ofNullable(clazz.cast(this.logExportsAsStrings()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNamespaceRequest, T> g) {
        return obj -> g.apply((CreateNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private String adminUserPassword;
        private String adminUsername;
        private String dbName;
        private String defaultIamRoleArn;
        private List<String> iamRoles = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private List<String> logExports = DefaultSdkAutoConstructList.getInstance();
        private String namespaceName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNamespaceRequest model) {
            super(model);
            this.adminUserPassword(model.adminUserPassword);
            this.adminUsername(model.adminUsername);
            this.dbName(model.dbName);
            this.defaultIamRoleArn(model.defaultIamRoleArn);
            this.iamRoles(model.iamRoles);
            this.kmsKeyId(model.kmsKeyId);
            this.logExportsWithStrings(model.logExports);
            this.namespaceName(model.namespaceName);
            this.tags(model.tags);
        }

        public final String getAdminUserPassword() {
            return this.adminUserPassword;
        }

        public final void setAdminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
        }

        @Override
        public final Builder adminUserPassword(String adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        public final String getAdminUsername() {
            return this.adminUsername;
        }

        public final void setAdminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
        }

        @Override
        public final Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public final String getDbName() {
            return this.dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return this.defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        public final Collection<String> getIamRoles() {
            if (this.iamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.iamRoles;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String ... iamRoles) {
            this.iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getLogExports() {
            if (this.logExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logExports;
        }

        public final void setLogExports(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
        }

        @Override
        public final Builder logExportsWithStrings(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExportsWithStrings(String ... logExports) {
            this.logExportsWithStrings(Arrays.asList(logExports));
            return this;
        }

        @Override
        public final Builder logExports(Collection<LogExport> logExports) {
            this.logExports = LogExportListCopier.copyEnumToString(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExports(LogExport ... logExports) {
            this.logExports(Arrays.asList(logExports));
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNamespaceRequest build() {
            return new CreateNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNamespaceRequest> {
        public Builder adminUserPassword(String var1);

        public Builder adminUsername(String var1);

        public Builder dbName(String var1);

        public Builder defaultIamRoleArn(String var1);

        public Builder iamRoles(Collection<String> var1);

        public Builder iamRoles(String ... var1);

        public Builder kmsKeyId(String var1);

        public Builder logExportsWithStrings(Collection<String> var1);

        public Builder logExportsWithStrings(String ... var1);

        public Builder logExports(Collection<LogExport> var1);

        public Builder logExports(LogExport ... var1);

        public Builder namespaceName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

