/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessServiceClientConfiguration;
import software.amazon.awssdk.services.redshiftserverless.model.AccessDeniedException;
import software.amazon.awssdk.services.redshiftserverless.model.ConflictException;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.InsufficientCapacityException;
import software.amazon.awssdk.services.redshiftserverless.model.InternalServerException;
import software.amazon.awssdk.services.redshiftserverless.model.InvalidPaginationException;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListNamespacesResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessException;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.TagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ThrottlingException;
import software.amazon.awssdk.services.redshiftserverless.model.TooManyTagsException;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UntagResourceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateEndpointAccessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateNamespaceResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateUsageLimitResponse;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.UpdateWorkgroupResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ValidationException;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListEndpointAccessIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListNamespacesIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListRecoveryPointsIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListSnapshotsIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListTableRestoreStatusIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListUsageLimitsIterable;
import software.amazon.awssdk.services.redshiftserverless.paginators.ListWorkgroupsIterable;
import software.amazon.awssdk.services.redshiftserverless.transform.ConvertRecoveryPointToSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.CreateWorkgroupRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.DeleteWorkgroupRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetCredentialsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.GetWorkgroupRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListRecoveryPointsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListUsageLimitsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.ListWorkgroupsRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreFromRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.RestoreTableFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshiftserverless.transform.UpdateWorkgroupRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRedshiftServerlessClient
implements RedshiftServerlessClient {
    private static final Logger log = Logger.loggerFor(DefaultRedshiftServerlessClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final RedshiftServerlessServiceClientConfiguration serviceClientConfiguration;

    protected DefaultRedshiftServerlessClient(RedshiftServerlessServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConvertRecoveryPointToSnapshotResponse convertRecoveryPointToSnapshot(ConvertRecoveryPointToSnapshotRequest convertRecoveryPointToSnapshotRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, TooManyTagsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConvertRecoveryPointToSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, convertRecoveryPointToSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConvertRecoveryPointToSnapshot");
            ConvertRecoveryPointToSnapshotResponse convertRecoveryPointToSnapshotResponse = (ConvertRecoveryPointToSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConvertRecoveryPointToSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)convertRecoveryPointToSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConvertRecoveryPointToSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return convertRecoveryPointToSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$convertRecoveryPointToSnapshot$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEndpointAccessResponse createEndpointAccess(CreateEndpointAccessRequest createEndpointAccessRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEndpointAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, createEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpointAccess");
            CreateEndpointAccessResponse createEndpointAccessResponse = (CreateEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpointAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$createEndpointAccess$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest createNamespaceRequest) throws InternalServerException, ConflictException, ValidationException, TooManyTagsException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNamespaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, createNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNamespace");
            CreateNamespaceResponse createNamespaceResponse = (CreateNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNamespace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$createNamespace$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, TooManyTagsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$createSnapshot$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUsageLimitResponse createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUsageLimitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, createUsageLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUsageLimit");
            CreateUsageLimitResponse createUsageLimitResponse = (CreateUsageLimitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUsageLimit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUsageLimitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUsageLimitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUsageLimitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$createUsageLimit$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkgroupResponse createWorkgroup(CreateWorkgroupRequest createWorkgroupRequest) throws InternalServerException, InsufficientCapacityException, ResourceNotFoundException, ConflictException, ValidationException, TooManyTagsException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkgroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, createWorkgroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkgroup");
            CreateWorkgroupResponse createWorkgroupResponse = (CreateWorkgroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkgroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkgroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkgroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkgroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$createWorkgroup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEndpointAccessResponse deleteEndpointAccess(DeleteEndpointAccessRequest deleteEndpointAccessRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, deleteEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpointAccess");
            DeleteEndpointAccessResponse deleteEndpointAccessResponse = (DeleteEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpointAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$deleteEndpointAccess$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamespaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, deleteNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNamespace");
            DeleteNamespaceResponse deleteNamespaceResponse = (DeleteNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamespace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$deleteNamespace$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$deleteResourcePolicy$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, deleteSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshot");
            DeleteSnapshotResponse deleteSnapshotResponse = (DeleteSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$deleteSnapshot$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUsageLimitResponse deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUsageLimitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, deleteUsageLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUsageLimit");
            DeleteUsageLimitResponse deleteUsageLimitResponse = (DeleteUsageLimitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUsageLimit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUsageLimitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteUsageLimitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUsageLimitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$deleteUsageLimit$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkgroupResponse deleteWorkgroup(DeleteWorkgroupRequest deleteWorkgroupRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkgroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkgroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkgroup");
            DeleteWorkgroupResponse deleteWorkgroupResponse = (DeleteWorkgroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkgroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkgroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkgroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkgroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$deleteWorkgroup$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCredentialsResponse getCredentials(GetCredentialsRequest getCredentialsRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCredentialsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, getCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCredentials");
            GetCredentialsResponse getCredentialsResponse = (GetCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCredentials").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCredentialsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCredentialsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$getCredentials$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEndpointAccessResponse getEndpointAccess(GetEndpointAccessRequest getEndpointAccessRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEndpointAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, getEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEndpointAccess");
            GetEndpointAccessResponse getEndpointAccessResponse = (GetEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEndpointAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$getEndpointAccess$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest getNamespaceRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamespaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, getNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNamespace");
            GetNamespaceResponse getNamespaceResponse = (GetNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamespace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$getNamespace$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecoveryPointResponse getRecoveryPoint(GetRecoveryPointRequest getRecoveryPointRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecoveryPointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, getRecoveryPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecoveryPoint");
            GetRecoveryPointResponse getRecoveryPointResponse = (GetRecoveryPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecoveryPoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRecoveryPointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRecoveryPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRecoveryPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$getRecoveryPoint$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            GetResourcePolicyResponse getResourcePolicyResponse = (GetResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$getResourcePolicy$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSnapshotResponse getSnapshot(GetSnapshotRequest getSnapshotRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, getSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSnapshot");
            GetSnapshotResponse getSnapshotResponse = (GetSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$getSnapshot$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTableRestoreStatusResponse getTableRestoreStatus(GetTableRestoreStatusRequest getTableRestoreStatusRequest) throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableRestoreStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, getTableRestoreStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTableRestoreStatus");
            GetTableRestoreStatusResponse getTableRestoreStatusResponse = (GetTableRestoreStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableRestoreStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTableRestoreStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTableRestoreStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTableRestoreStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$getTableRestoreStatus$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUsageLimitResponse getUsageLimit(GetUsageLimitRequest getUsageLimitRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUsageLimitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, getUsageLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUsageLimit");
            GetUsageLimitResponse getUsageLimitResponse = (GetUsageLimitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUsageLimit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUsageLimitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUsageLimitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUsageLimitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$getUsageLimit$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkgroupResponse getWorkgroup(GetWorkgroupRequest getWorkgroupRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkgroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, getWorkgroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkgroup");
            GetWorkgroupResponse getWorkgroupResponse = (GetWorkgroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkgroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getWorkgroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWorkgroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWorkgroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$getWorkgroup$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEndpointAccessResponse listEndpointAccess(ListEndpointAccessRequest listEndpointAccessRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEndpointAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, listEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEndpointAccess");
            ListEndpointAccessResponse listEndpointAccessResponse = (ListEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEndpointAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$listEndpointAccess$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEndpointAccessIterable listEndpointAccessPaginator(ListEndpointAccessRequest listEndpointAccessRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListEndpointAccessIterable(this, this.applyPaginatorUserAgent(listEndpointAccessRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNamespacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, listNamespacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNamespaces");
            ListNamespacesResponse listNamespacesResponse = (ListNamespacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNamespaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNamespacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNamespacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNamespacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$listNamespaces$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListNamespacesIterable listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListNamespacesIterable(this, this.applyPaginatorUserAgent(listNamespacesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecoveryPointsResponse listRecoveryPoints(ListRecoveryPointsRequest listRecoveryPointsRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecoveryPointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, listRecoveryPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecoveryPoints");
            ListRecoveryPointsResponse listRecoveryPointsResponse = (ListRecoveryPointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecoveryPoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecoveryPointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecoveryPointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecoveryPointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$listRecoveryPoints$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRecoveryPointsIterable listRecoveryPointsPaginator(ListRecoveryPointsRequest listRecoveryPointsRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListRecoveryPointsIterable(this, this.applyPaginatorUserAgent(listRecoveryPointsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSnapshotsResponse listSnapshots(ListSnapshotsRequest listSnapshotsRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, listSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSnapshots");
            ListSnapshotsResponse listSnapshotsResponse = (ListSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$listSnapshots$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSnapshotsIterable listSnapshotsPaginator(ListSnapshotsRequest listSnapshotsRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListSnapshotsIterable(this, this.applyPaginatorUserAgent(listSnapshotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTableRestoreStatusResponse listTableRestoreStatus(ListTableRestoreStatusRequest listTableRestoreStatusRequest) throws InvalidPaginationException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableRestoreStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, listTableRestoreStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTableRestoreStatus");
            ListTableRestoreStatusResponse listTableRestoreStatusResponse = (ListTableRestoreStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableRestoreStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTableRestoreStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTableRestoreStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTableRestoreStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$listTableRestoreStatus$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTableRestoreStatusIterable listTableRestoreStatusPaginator(ListTableRestoreStatusRequest listTableRestoreStatusRequest) throws InvalidPaginationException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListTableRestoreStatusIterable(this, this.applyPaginatorUserAgent(listTableRestoreStatusRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$listTagsForResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsageLimitsResponse listUsageLimits(ListUsageLimitsRequest listUsageLimitsRequest) throws InternalServerException, InvalidPaginationException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsageLimitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, listUsageLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsageLimits");
            ListUsageLimitsResponse listUsageLimitsResponse = (ListUsageLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsageLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsageLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsageLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsageLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$listUsageLimits$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListUsageLimitsIterable listUsageLimitsPaginator(ListUsageLimitsRequest listUsageLimitsRequest) throws InternalServerException, InvalidPaginationException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListUsageLimitsIterable(this, this.applyPaginatorUserAgent(listUsageLimitsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkgroupsResponse listWorkgroups(ListWorkgroupsRequest listWorkgroupsRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkgroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, listWorkgroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkgroups");
            ListWorkgroupsResponse listWorkgroupsResponse = (ListWorkgroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkgroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkgroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkgroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkgroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$listWorkgroups$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorkgroupsIterable listWorkgroupsPaginator(ListWorkgroupsRequest listWorkgroupsRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        return new ListWorkgroupsIterable(this, this.applyPaginatorUserAgent(listWorkgroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$putResourcePolicy$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreFromRecoveryPointResponse restoreFromRecoveryPoint(RestoreFromRecoveryPointRequest restoreFromRecoveryPointRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreFromRecoveryPointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, restoreFromRecoveryPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreFromRecoveryPoint");
            RestoreFromRecoveryPointResponse restoreFromRecoveryPointResponse = (RestoreFromRecoveryPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreFromRecoveryPoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreFromRecoveryPointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreFromRecoveryPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreFromRecoveryPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$restoreFromRecoveryPoint$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreFromSnapshotResponse restoreFromSnapshot(RestoreFromSnapshotRequest restoreFromSnapshotRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreFromSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, restoreFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreFromSnapshot");
            RestoreFromSnapshotResponse restoreFromSnapshotResponse = (RestoreFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreFromSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$restoreFromSnapshot$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreTableFromSnapshotResponse restoreTableFromSnapshot(RestoreTableFromSnapshotRequest restoreTableFromSnapshotRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableFromSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, restoreTableFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableFromSnapshot");
            RestoreTableFromSnapshotResponse restoreTableFromSnapshotResponse = (RestoreTableFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableFromSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreTableFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreTableFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreTableFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$restoreTableFromSnapshot$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, TooManyTagsException, ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$tagResource$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$untagResource$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEndpointAccessResponse updateEndpointAccess(UpdateEndpointAccessRequest updateEndpointAccessRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEndpointAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, updateEndpointAccessRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEndpointAccess");
            UpdateEndpointAccessResponse updateEndpointAccessResponse = (UpdateEndpointAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEndpointAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEndpointAccessRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEndpointAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEndpointAccessResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$updateEndpointAccess$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNamespaceResponse updateNamespace(UpdateNamespaceRequest updateNamespaceRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNamespaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, updateNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNamespace");
            UpdateNamespaceResponse updateNamespaceResponse = (UpdateNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNamespace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$updateNamespace$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSnapshotResponse updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, updateSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSnapshot");
            UpdateSnapshotResponse updateSnapshotResponse = (UpdateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$updateSnapshot$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUsageLimitResponse updateUsageLimit(UpdateUsageLimitRequest updateUsageLimitRequest) throws InternalServerException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUsageLimitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, updateUsageLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUsageLimit");
            UpdateUsageLimitResponse updateUsageLimitResponse = (UpdateUsageLimitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUsageLimit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUsageLimitRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUsageLimitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUsageLimitResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$updateUsageLimit$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkgroupResponse updateWorkgroup(UpdateWorkgroupRequest updateWorkgroupRequest) throws InternalServerException, InsufficientCapacityException, ResourceNotFoundException, ConflictException, ValidationException, AwsServiceException, SdkClientException, RedshiftServerlessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkgroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRedshiftServerlessClient.resolveMetricPublishers(this.clientConfiguration, updateWorkgroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Serverless");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkgroup");
            UpdateWorkgroupResponse updateWorkgroupResponse = (UpdateWorkgroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkgroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorkgroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkgroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkgroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftServerlessClient.lambda$updateWorkgroup$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends RedshiftServerlessRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.64").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RedshiftServerlessRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "redshift-serverless";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RedshiftServerlessException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationException").exceptionBuilderSupplier(InvalidPaginationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").exceptionBuilderSupplier(InsufficientCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final RedshiftServerlessServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateWorkgroup$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUsageLimit$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSnapshot$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNamespace$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEndpointAccess$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableFromSnapshot$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreFromSnapshot$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreFromRecoveryPoint$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkgroups$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsageLimits$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTableRestoreStatus$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSnapshots$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecoveryPoints$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNamespaces$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEndpointAccess$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkgroup$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUsageLimit$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTableRestoreStatus$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSnapshot$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecoveryPoint$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNamespace$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEndpointAccess$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCredentials$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkgroup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUsageLimit$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshot$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNamespace$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpointAccess$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkgroup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUsageLimit$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshot$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNamespace$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEndpointAccess$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$convertRecoveryPointToSnapshot$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

