/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.IamRoleArnListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.LogExport;
import software.amazon.awssdk.services.redshiftserverless.model.LogExportListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.NamespaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Namespace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Namespace> {
    private static final SdkField<String> ADMIN_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminUsername").getter(Namespace.getter(Namespace::adminUsername)).setter(Namespace.setter(Builder::adminUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUsername").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(Namespace.getter(Namespace::creationDate)).setter(Namespace.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbName").getter(Namespace.getter(Namespace::dbName)).setter(Namespace.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbName").build()}).build();
    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultIamRoleArn").getter(Namespace.getter(Namespace::defaultIamRoleArn)).setter(Namespace.setter(Builder::defaultIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultIamRoleArn").build()}).build();
    private static final SdkField<List<String>> IAM_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("iamRoles").getter(Namespace.getter(Namespace::iamRoles)).setter(Namespace.setter(Builder::iamRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(Namespace.getter(Namespace::kmsKeyId)).setter(Namespace.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<List<String>> LOG_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logExports").getter(Namespace.getter(Namespace::logExportsAsStrings)).setter(Namespace.setter(Builder::logExportsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceArn").getter(Namespace.getter(Namespace::namespaceArn)).setter(Namespace.setter(Builder::namespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()}).build();
    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceId").getter(Namespace.getter(Namespace::namespaceId)).setter(Namespace.setter(Builder::namespaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceId").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(Namespace.getter(Namespace::namespaceName)).setter(Namespace.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Namespace.getter(Namespace::statusAsString)).setter(Namespace.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USERNAME_FIELD, CREATION_DATE_FIELD, DB_NAME_FIELD, DEFAULT_IAM_ROLE_ARN_FIELD, IAM_ROLES_FIELD, KMS_KEY_ID_FIELD, LOG_EXPORTS_FIELD, NAMESPACE_ARN_FIELD, NAMESPACE_ID_FIELD, NAMESPACE_NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adminUsername;
    private final Instant creationDate;
    private final String dbName;
    private final String defaultIamRoleArn;
    private final List<String> iamRoles;
    private final String kmsKeyId;
    private final List<String> logExports;
    private final String namespaceArn;
    private final String namespaceId;
    private final String namespaceName;
    private final String status;

    private Namespace(BuilderImpl builder) {
        this.adminUsername = builder.adminUsername;
        this.creationDate = builder.creationDate;
        this.dbName = builder.dbName;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
        this.iamRoles = builder.iamRoles;
        this.kmsKeyId = builder.kmsKeyId;
        this.logExports = builder.logExports;
        this.namespaceArn = builder.namespaceArn;
        this.namespaceId = builder.namespaceId;
        this.namespaceName = builder.namespaceName;
        this.status = builder.status;
    }

    public final String adminUsername() {
        return this.adminUsername;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String dbName() {
        return this.dbName;
    }

    public final String defaultIamRoleArn() {
        return this.defaultIamRoleArn;
    }

    public final boolean hasIamRoles() {
        return this.iamRoles != null && !(this.iamRoles instanceof SdkAutoConstructList);
    }

    public final List<String> iamRoles() {
        return this.iamRoles;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final List<LogExport> logExports() {
        return LogExportListCopier.copyStringToEnum(this.logExports);
    }

    public final boolean hasLogExports() {
        return this.logExports != null && !(this.logExports instanceof SdkAutoConstructList);
    }

    public final List<String> logExportsAsStrings() {
        return this.logExports;
    }

    public final String namespaceArn() {
        return this.namespaceArn;
    }

    public final String namespaceId() {
        return this.namespaceId;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final NamespaceStatus status() {
        return NamespaceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adminUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIamRoles() ? this.iamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogExports() ? this.logExportsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace)obj;
        return Objects.equals(this.adminUsername(), other.adminUsername()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.defaultIamRoleArn(), other.defaultIamRoleArn()) && this.hasIamRoles() == other.hasIamRoles() && Objects.equals(this.iamRoles(), other.iamRoles()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasLogExports() == other.hasLogExports() && Objects.equals(this.logExportsAsStrings(), other.logExportsAsStrings()) && Objects.equals(this.namespaceArn(), other.namespaceArn()) && Objects.equals(this.namespaceId(), other.namespaceId()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Namespace").add("AdminUsername", (Object)(this.adminUsername() == null ? null : "*** Sensitive Data Redacted ***")).add("CreationDate", (Object)this.creationDate()).add("DbName", (Object)this.dbName()).add("DefaultIamRoleArn", (Object)this.defaultIamRoleArn()).add("IamRoles", this.hasIamRoles() ? this.iamRoles() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("LogExports", this.hasLogExports() ? this.logExportsAsStrings() : null).add("NamespaceArn", (Object)this.namespaceArn()).add("NamespaceId", (Object)this.namespaceId()).add("NamespaceName", (Object)this.namespaceName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminUsername": {
                return Optional.ofNullable(clazz.cast(this.adminUsername()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "dbName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "defaultIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.defaultIamRoleArn()));
            }
            case "iamRoles": {
                return Optional.ofNullable(clazz.cast(this.iamRoles()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "logExports": {
                return Optional.ofNullable(clazz.cast(this.logExportsAsStrings()));
            }
            case "namespaceArn": {
                return Optional.ofNullable(clazz.cast(this.namespaceArn()));
            }
            case "namespaceId": {
                return Optional.ofNullable(clazz.cast(this.namespaceId()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Namespace, T> g) {
        return obj -> g.apply((Namespace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adminUsername;
        private Instant creationDate;
        private String dbName;
        private String defaultIamRoleArn;
        private List<String> iamRoles = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private List<String> logExports = DefaultSdkAutoConstructList.getInstance();
        private String namespaceArn;
        private String namespaceId;
        private String namespaceName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Namespace model) {
            this.adminUsername(model.adminUsername);
            this.creationDate(model.creationDate);
            this.dbName(model.dbName);
            this.defaultIamRoleArn(model.defaultIamRoleArn);
            this.iamRoles(model.iamRoles);
            this.kmsKeyId(model.kmsKeyId);
            this.logExportsWithStrings(model.logExports);
            this.namespaceArn(model.namespaceArn);
            this.namespaceId(model.namespaceId);
            this.namespaceName(model.namespaceName);
            this.status(model.status);
        }

        public final String getAdminUsername() {
            return this.adminUsername;
        }

        public final void setAdminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
        }

        @Override
        public final Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDbName() {
            return this.dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return this.defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        public final Collection<String> getIamRoles() {
            if (this.iamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.iamRoles;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String ... iamRoles) {
            this.iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getLogExports() {
            if (this.logExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logExports;
        }

        public final void setLogExports(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
        }

        @Override
        public final Builder logExportsWithStrings(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExportsWithStrings(String ... logExports) {
            this.logExportsWithStrings(Arrays.asList(logExports));
            return this;
        }

        @Override
        public final Builder logExports(Collection<LogExport> logExports) {
            this.logExports = LogExportListCopier.copyEnumToString(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExports(LogExport ... logExports) {
            this.logExports(Arrays.asList(logExports));
            return this;
        }

        public final String getNamespaceArn() {
            return this.namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceId() {
            return this.namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NamespaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public Namespace build() {
            return new Namespace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Namespace> {
        public Builder adminUsername(String var1);

        public Builder creationDate(Instant var1);

        public Builder dbName(String var1);

        public Builder defaultIamRoleArn(String var1);

        public Builder iamRoles(Collection<String> var1);

        public Builder iamRoles(String ... var1);

        public Builder kmsKeyId(String var1);

        public Builder logExportsWithStrings(Collection<String> var1);

        public Builder logExportsWithStrings(String ... var1);

        public Builder logExports(Collection<LogExport> var1);

        public Builder logExports(LogExport ... var1);

        public Builder namespaceArn(String var1);

        public Builder namespaceId(String var1);

        public Builder namespaceName(String var1);

        public Builder status(String var1);

        public Builder status(NamespaceStatus var1);
    }
}

