/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata;
import software.amazon.awssdk.services.redshiftdata.model.ColumnMetadataListCopier;
import software.amazon.awssdk.services.redshiftdata.model.FormattedSqlRecordsCopier;
import software.amazon.awssdk.services.redshiftdata.model.QueryRecords;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataResponse;
import software.amazon.awssdk.services.redshiftdata.model.ResultFormatString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStatementResultV2Response
extends RedshiftDataResponse
implements ToCopyableBuilder<Builder, GetStatementResultV2Response> {
    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnMetadata").getter(GetStatementResultV2Response.getter(GetStatementResultV2Response::columnMetadata)).setter(GetStatementResultV2Response.setter(Builder::columnMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetStatementResultV2Response.getter(GetStatementResultV2Response::nextToken)).setter(GetStatementResultV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<QueryRecords>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(GetStatementResultV2Response.getter(GetStatementResultV2Response::records)).setter(GetStatementResultV2Response.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryRecords::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultFormat").getter(GetStatementResultV2Response.getter(GetStatementResultV2Response::resultFormatAsString)).setter(GetStatementResultV2Response.setter(Builder::resultFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultFormat").build()}).build();
    private static final SdkField<Long> TOTAL_NUM_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalNumRows").getter(GetStatementResultV2Response.getter(GetStatementResultV2Response::totalNumRows)).setter(GetStatementResultV2Response.setter(Builder::totalNumRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumRows").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_METADATA_FIELD, NEXT_TOKEN_FIELD, RECORDS_FIELD, RESULT_FORMAT_FIELD, TOTAL_NUM_ROWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetStatementResultV2Response.memberNameToFieldInitializer();
    private final List<ColumnMetadata> columnMetadata;
    private final String nextToken;
    private final List<QueryRecords> records;
    private final String resultFormat;
    private final Long totalNumRows;

    private GetStatementResultV2Response(BuilderImpl builder) {
        super(builder);
        this.columnMetadata = builder.columnMetadata;
        this.nextToken = builder.nextToken;
        this.records = builder.records;
        this.resultFormat = builder.resultFormat;
        this.totalNumRows = builder.totalNumRows;
    }

    public final boolean hasColumnMetadata() {
        return this.columnMetadata != null && !(this.columnMetadata instanceof SdkAutoConstructList);
    }

    public final List<ColumnMetadata> columnMetadata() {
        return this.columnMetadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<QueryRecords> records() {
        return this.records;
    }

    public final ResultFormatString resultFormat() {
        return ResultFormatString.fromValue(this.resultFormat);
    }

    public final String resultFormatAsString() {
        return this.resultFormat;
    }

    public final Long totalNumRows() {
        return this.totalNumRows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnMetadata() ? this.columnMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resultFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumRows());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStatementResultV2Response)) {
            return false;
        }
        GetStatementResultV2Response other = (GetStatementResultV2Response)((Object)obj);
        return this.hasColumnMetadata() == other.hasColumnMetadata() && Objects.equals(this.columnMetadata(), other.columnMetadata()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.resultFormatAsString(), other.resultFormatAsString()) && Objects.equals(this.totalNumRows(), other.totalNumRows());
    }

    public final String toString() {
        return ToString.builder((String)"GetStatementResultV2Response").add("ColumnMetadata", this.hasColumnMetadata() ? this.columnMetadata() : null).add("NextToken", (Object)this.nextToken()).add("Records", this.hasRecords() ? this.records() : null).add("ResultFormat", (Object)this.resultFormatAsString()).add("TotalNumRows", (Object)this.totalNumRows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnMetadata": {
                return Optional.ofNullable(clazz.cast(this.columnMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "ResultFormat": {
                return Optional.ofNullable(clazz.cast(this.resultFormatAsString()));
            }
            case "TotalNumRows": {
                return Optional.ofNullable(clazz.cast(this.totalNumRows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ColumnMetadata", COLUMN_METADATA_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Records", RECORDS_FIELD);
        map.put("ResultFormat", RESULT_FORMAT_FIELD);
        map.put("TotalNumRows", TOTAL_NUM_ROWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStatementResultV2Response, T> g) {
        return obj -> g.apply((GetStatementResultV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataResponse.BuilderImpl
    implements Builder {
        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<QueryRecords> records = DefaultSdkAutoConstructList.getInstance();
        private String resultFormat;
        private Long totalNumRows;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStatementResultV2Response model) {
            super(model);
            this.columnMetadata(model.columnMetadata);
            this.nextToken(model.nextToken);
            this.records(model.records);
            this.resultFormat(model.resultFormat);
            this.totalNumRows(model.totalNumRows);
        }

        public final List<ColumnMetadata.Builder> getColumnMetadata() {
            List<ColumnMetadata.Builder> result = ColumnMetadataListCopier.copyToBuilder(this.columnMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copyFromBuilder(columnMetadata);
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata ... columnMetadata) {
            this.columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... columnMetadata) {
            this.columnMetadata(Stream.of(columnMetadata).map(c -> (ColumnMetadata)((ColumnMetadata.Builder)ColumnMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QueryRecords.Builder> getRecords() {
            List<QueryRecords.Builder> result = FormattedSqlRecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<QueryRecords.BuilderImpl> records) {
            this.records = FormattedSqlRecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<QueryRecords> records) {
            this.records = FormattedSqlRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(QueryRecords ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<QueryRecords.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (QueryRecords)((QueryRecords.Builder)QueryRecords.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResultFormat() {
            return this.resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormatString resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        public final Long getTotalNumRows() {
            return this.totalNumRows;
        }

        public final void setTotalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
        }

        @Override
        public final Builder totalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
            return this;
        }

        @Override
        public GetStatementResultV2Response build() {
            return new GetStatementResultV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStatementResultV2Response> {
        public Builder columnMetadata(Collection<ColumnMetadata> var1);

        public Builder columnMetadata(ColumnMetadata ... var1);

        public Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder records(Collection<QueryRecords> var1);

        public Builder records(QueryRecords ... var1);

        public Builder records(Consumer<QueryRecords.Builder> ... var1);

        public Builder resultFormat(String var1);

        public Builder resultFormat(ResultFormatString var1);

        public Builder totalNumRows(Long var1);
    }
}

