/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StatusString {
    SUBMITTED("SUBMITTED"),
    PICKED("PICKED"),
    STARTED("STARTED"),
    FINISHED("FINISHED"),
    ABORTED("ABORTED"),
    FAILED("FAILED"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StatusString(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatusString fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StatusString.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatusString> knownValues() {
        return Stream.of(StatusString.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

