/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Field
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Field> {
    private static final SdkField<SdkBytes> BLOB_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("blobValue").getter(Field.getter(Field::blobValue)).setter(Field.setter(Builder::blobValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobValue").build()}).build();
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("booleanValue").getter(Field.getter(Field::booleanValue)).setter(Field.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("doubleValue").getter(Field.getter(Field::doubleValue)).setter(Field.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<Boolean> IS_NULL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isNull").getter(Field.getter(Field::isNull)).setter(Field.setter(Builder::isNull)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNull").build()}).build();
    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("longValue").getter(Field.getter(Field::longValue)).setter(Field.setter(Builder::longValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(Field.getter(Field::stringValue)).setter(Field.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOB_VALUE_FIELD, BOOLEAN_VALUE_FIELD, DOUBLE_VALUE_FIELD, IS_NULL_FIELD, LONG_VALUE_FIELD, STRING_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes blobValue;
    private final Boolean booleanValue;
    private final Double doubleValue;
    private final Boolean isNull;
    private final Long longValue;
    private final String stringValue;
    private final Type type;

    private Field(BuilderImpl builder) {
        this.blobValue = builder.blobValue;
        this.booleanValue = builder.booleanValue;
        this.doubleValue = builder.doubleValue;
        this.isNull = builder.isNull;
        this.longValue = builder.longValue;
        this.stringValue = builder.stringValue;
        this.type = builder.type;
    }

    public final SdkBytes blobValue() {
        return this.blobValue;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final Boolean isNull() {
        return this.isNull;
    }

    public final Long longValue() {
        return this.longValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blobValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.isNull());
        hashCode = 31 * hashCode + Objects.hashCode(this.longValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        return Objects.equals(this.blobValue(), other.blobValue()) && Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.isNull(), other.isNull()) && Objects.equals(this.longValue(), other.longValue()) && Objects.equals(this.stringValue(), other.stringValue());
    }

    public final String toString() {
        return ToString.builder((String)"Field").add("BlobValue", (Object)this.blobValue()).add("BooleanValue", (Object)this.booleanValue()).add("DoubleValue", (Object)this.doubleValue()).add("IsNull", (Object)this.isNull()).add("LongValue", (Object)this.longValue()).add("StringValue", (Object)this.stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blobValue": {
                return Optional.ofNullable(clazz.cast(this.blobValue()));
            }
            case "booleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "isNull": {
                return Optional.ofNullable(clazz.cast(this.isNull()));
            }
            case "longValue": {
                return Optional.ofNullable(clazz.cast(this.longValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
        }
        return Optional.empty();
    }

    public static Field fromBlobValue(SdkBytes blobValue) {
        return (Field)Field.builder().blobValue(blobValue).build();
    }

    public static Field fromBooleanValue(Boolean booleanValue) {
        return (Field)Field.builder().booleanValue(booleanValue).build();
    }

    public static Field fromDoubleValue(Double doubleValue) {
        return (Field)Field.builder().doubleValue(doubleValue).build();
    }

    public static Field fromIsNull(Boolean isNull) {
        return (Field)Field.builder().isNull(isNull).build();
    }

    public static Field fromLongValue(Long longValue) {
        return (Field)Field.builder().longValue(longValue).build();
    }

    public static Field fromStringValue(String stringValue) {
        return (Field)Field.builder().stringValue(stringValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Field, T> g) {
        return obj -> g.apply((Field)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BLOB_VALUE,
        BOOLEAN_VALUE,
        DOUBLE_VALUE,
        IS_NULL,
        LONG_VALUE,
        STRING_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes blobValue;
        private Boolean booleanValue;
        private Double doubleValue;
        private Boolean isNull;
        private Long longValue;
        private String stringValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            this.blobValue(model.blobValue);
            this.booleanValue(model.booleanValue);
            this.doubleValue(model.doubleValue);
            this.isNull(model.isNull);
            this.longValue(model.longValue);
            this.stringValue(model.stringValue);
        }

        public final ByteBuffer getBlobValue() {
            return this.blobValue == null ? null : this.blobValue.asByteBuffer();
        }

        public final void setBlobValue(ByteBuffer blobValue) {
            this.blobValue(blobValue == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blobValue));
        }

        @Override
        @Transient
        public final Builder blobValue(SdkBytes blobValue) {
            SdkBytes oldValue = this.blobValue;
            this.blobValue = blobValue;
            this.handleUnionValueChange(Type.BLOB_VALUE, oldValue, this.blobValue);
            return this;
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        @Transient
        public final Builder booleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        @Transient
        public final Builder doubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final Boolean getIsNull() {
            return this.isNull;
        }

        public final void setIsNull(Boolean isNull) {
            Boolean oldValue = this.isNull;
            this.isNull = isNull;
            this.handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
        }

        @Override
        @Transient
        public final Builder isNull(Boolean isNull) {
            Boolean oldValue = this.isNull;
            this.isNull = isNull;
            this.handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
            return this;
        }

        public final Long getLongValue() {
            return this.longValue;
        }

        public final void setLongValue(Long longValue) {
            Long oldValue = this.longValue;
            this.longValue = longValue;
            this.handleUnionValueChange(Type.LONG_VALUE, oldValue, this.longValue);
        }

        @Override
        @Transient
        public final Builder longValue(Long longValue) {
            Long oldValue = this.longValue;
            this.longValue = longValue;
            this.handleUnionValueChange(Type.LONG_VALUE, oldValue, this.longValue);
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        @Transient
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public Field build() {
            return new Field(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Field> {
        public Builder blobValue(SdkBytes var1);

        public Builder booleanValue(Boolean var1);

        public Builder doubleValue(Double var1);

        public Builder isNull(Boolean var1);

        public Builder longValue(Long var1);

        public Builder stringValue(String var1);
    }
}

