/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOptionsListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrderableClusterOptionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeOrderableClusterOptionsResponse> {
    private static final SdkField<List<OrderableClusterOption>> ORDERABLE_CLUSTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeOrderableClusterOptionsResponse.getter(DescribeOrderableClusterOptionsResponse::orderableClusterOptions)).setter(DescribeOrderableClusterOptionsResponse.setter(Builder::orderableClusterOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableClusterOptions").build(), ListTrait.builder().memberLocationName("OrderableClusterOption").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrderableClusterOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableClusterOption").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeOrderableClusterOptionsResponse.getter(DescribeOrderableClusterOptionsResponse::marker)).setter(DescribeOrderableClusterOptionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDERABLE_CLUSTER_OPTIONS_FIELD, MARKER_FIELD));
    private final List<OrderableClusterOption> orderableClusterOptions;
    private final String marker;

    private DescribeOrderableClusterOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.orderableClusterOptions = builder.orderableClusterOptions;
        this.marker = builder.marker;
    }

    public List<OrderableClusterOption> orderableClusterOptions() {
        return this.orderableClusterOptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orderableClusterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableClusterOptionsResponse)) {
            return false;
        }
        DescribeOrderableClusterOptionsResponse other = (DescribeOrderableClusterOptionsResponse)((Object)obj);
        return Objects.equals(this.orderableClusterOptions(), other.orderableClusterOptions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOrderableClusterOptionsResponse").add("OrderableClusterOptions", this.orderableClusterOptions()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderableClusterOptions": {
                return Optional.ofNullable(clazz.cast(this.orderableClusterOptions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrderableClusterOptionsResponse, T> g) {
        return obj -> g.apply((DescribeOrderableClusterOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<OrderableClusterOption> orderableClusterOptions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableClusterOptionsResponse model) {
            super(model);
            this.orderableClusterOptions(model.orderableClusterOptions);
            this.marker(model.marker);
        }

        public final Collection<OrderableClusterOption.Builder> getOrderableClusterOptions() {
            return this.orderableClusterOptions != null ? (Collection)this.orderableClusterOptions.stream().map(OrderableClusterOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderableClusterOptions(Collection<OrderableClusterOption> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copy(orderableClusterOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableClusterOptions(OrderableClusterOption ... orderableClusterOptions) {
            this.orderableClusterOptions(Arrays.asList(orderableClusterOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableClusterOptions(Consumer<OrderableClusterOption.Builder> ... orderableClusterOptions) {
            this.orderableClusterOptions(Stream.of(orderableClusterOptions).map(c -> (OrderableClusterOption)((OrderableClusterOption.Builder)OrderableClusterOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderableClusterOptions(Collection<OrderableClusterOption.BuilderImpl> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copyFromBuilder(orderableClusterOptions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOrderableClusterOptionsResponse build() {
            return new DescribeOrderableClusterOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrderableClusterOptionsResponse> {
        public Builder orderableClusterOptions(Collection<OrderableClusterOption> var1);

        public Builder orderableClusterOptions(OrderableClusterOption ... var1);

        public Builder orderableClusterOptions(Consumer<OrderableClusterOption.Builder> ... var1);

        public Builder marker(String var1);
    }
}

